/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.client.ui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import ma.shaur.gsscs.client.KeyHandler;
import ma.shaur.gsscs.client.ui.DrawingUtil;
import ma.shaur.gsscs.mixin.client.GuiGraphicsInvoker;
import ma.shaur.gsscs.mixin.client.KeyMappingAccessor;
import ma.shaur.gsscs.network.packets.clientbound.ClientNetworkHandler;
import ma.shaur.gsscs.network.packets.serverbound.SpellCastEndPacketPayload;
import ma.shaur.gsscs.network.packets.serverbound.SpellPacketPayload;
import ma.shaur.gsscs.spells.symbols.Recognizer;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class CastScreen
extends Screen {
    private static final int SPELL_HEIGHT = 120;
    private static long LAST_CLOSED = 0L;
    private final int backgroundColor = 790239770;
    private final int outlineColor = 0x300A0A0A;
    private int y = 0;
    private int x = 0;
    private int yMax = 0;
    private int xMax = 0;
    private DynamicTexture spell;
    private ArrayList<Recognizer.Point> points = new ArrayList();
    private int lastStoke = -1;

    public CastScreen() {
        super(GameNarrator.NO_TITLE);
    }

    public static long getLastClosed() {
        return LAST_CLOSED;
    }

    protected void init() {
        this.y = this.height / 20;
        this.x = this.width / 20;
        this.yMax = this.y * 19;
        this.xMax = this.x * 19;
        this.spell = new DynamicTexture("spell_input_texture", (int)(120.0f * ((float)(this.xMax - this.x) / (float)(this.yMax - this.y))), 120, true);
        this.spell.upload();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (InputConstants.isKeyDown((Window)this.minecraft.getWindow(), (int)((KeyMappingAccessor)KeyHandler.CAST_KEY).key().getValue())) {
            ((GuiGraphicsInvoker)guiGraphics).invokeSubmitBlit(RenderPipelines.GUI_TEXTURED, this.spell.getTextureView(), this.x + 1, this.y + 1, this.xMax - 1, this.yMax - 1, 0.0f, 1.0f, 0.0f, 1.0f, -1);
        } else {
            this.minecraft.setScreen(null);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(this.x, this.y, this.xMax, this.yMax, 790239770);
        guiGraphics.submitOutline(this.x, this.y, this.xMax - this.x, this.yMax - this.y, 0x300A0A0A);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        if (event.button() == 0 && event.x() - mouseX >= (double)this.x && event.x() - mouseX < (double)this.xMax && event.y() - mouseY >= (double)this.y && event.y() - mouseY < (double)this.yMax) {
            float width = this.xMax - this.x - 2;
            float height = this.yMax - this.y - 2;
            float xRel = (float)(event.x() - (double)this.x - 1.0) / width;
            float yRel = (float)(event.y() - (double)this.y - 1.0) / height;
            float xPrevRel = (float)(event.x() - mouseX - (double)this.x - 1.0) / width;
            float yPrevRel = (float)(event.y() - mouseY - (double)this.y - 1.0) / height;
            int tWidth = this.spell.getPixels().getWidth();
            int tHeight = this.spell.getPixels().getHeight();
            int x0 = (int)(xPrevRel * (float)tWidth);
            int x1 = (int)(xRel * (float)tWidth);
            int y0 = (int)(yPrevRel * (float)tHeight);
            int y1 = (int)(yRel * (float)tHeight);
            this.points.add(new Recognizer.Point(x0, y0, ++this.lastStoke));
            this.points.add(new Recognizer.Point(x1, y1, this.lastStoke));
            if (!DrawingUtil.line(this.spell.getPixels(), x0, y0, x1, y1, -16776961)) {
                NetworkManager.sendToServer((CustomPacketPayload)new SpellCastEndPacketPayload(false));
                return true;
            }
            this.spell.upload();
            return true;
        }
        return super.mouseDragged(event, mouseX, mouseY);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (event.button() == 0) {
            ClientNetworkHandler.sendPoints(new SpellPacketPayload((Recognizer.Point[])this.points.toArray(Recognizer.Point[]::new)));
        } else if (event.button() == 1) {
            this.clearUnrecongised();
        }
        return super.mouseReleased(event);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return true;
    }

    public boolean keyPressed(KeyEvent event) {
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void removed() {
        super.removed();
        if (this.spell != null) {
            this.spell.close();
        }
        ClientNetworkHandler.clearQueue();
        NetworkManager.sendToServer((CustomPacketPayload)new SpellCastEndPacketPayload(true));
        LAST_CLOSED = System.currentTimeMillis();
    }

    public void recongised(Recognizer.Point[] points) {
        this.points = new ArrayList();
        NativeImage pixels = this.spell.getPixels();
        for (int i = 0; i < points.length; i += 2) {
            DrawingUtil.line(pixels, (int)points[i].getX(), (int)points[i].getY(), (int)points[i + 1].getX(), (int)points[i + 1].getY(), -16777216, true);
        }
        this.spell.upload();
    }

    private void clearUnrecongised() {
        ClientNetworkHandler.clearQueue();
        this.points = new ArrayList();
        NativeImage pixels = this.spell.getPixels();
        for (int x = 0; x < pixels.getWidth(); ++x) {
            for (int y = 0; y < pixels.getHeight(); ++y) {
                if (pixels.getPixel(x, y) != -65536) continue;
                pixels.setPixelABGR(x, y, 0);
            }
        }
        this.spell.upload();
    }
}

