/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.client.ui;

import com.mojang.blaze3d.platform.NativeImage;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ma.shaur.gsscs.GSSCS;
import ma.shaur.gsscs.client.ui.DrawingUtil;
import ma.shaur.gsscs.mixin.client.GuiGraphicsInvoker;
import ma.shaur.gsscs.spells.symbols.AbstractSymbol;
import ma.shaur.gsscs.spells.symbols.AffectSymbol;
import ma.shaur.gsscs.spells.symbols.ElementSymbol;
import ma.shaur.gsscs.spells.symbols.FormSymbol;
import ma.shaur.gsscs.spells.symbols.Recognizer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class SymbolBookScreen
extends Screen {
    private static final int BACKGROUND_TEXTURE_WIDTH = 256;
    private static final int BACKGROUND_TEXTURE_HEIGHT = 256;
    private static final int IMAGE_WIDTH = 192;
    private static final int IMAGE_HEIGHT = 192;
    private static final int CONTENT_WIDTH = 108;
    private static final int CONTENT_HEIGHT = 108;
    public static final ResourceLocation BACKGROUND_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/book.png");
    private PageButton forwardButton;
    private PageButton backButton;
    private int currentPage;
    private Map<String, AbstractSymbol> symbols = GSSCS.getIdentifier().symbols();
    private List<AbstractWidget> pageWidgets = new ArrayList<AbstractWidget>();
    private String currentSymbol;
    private Float distance = Float.valueOf(Float.POSITIVE_INFINITY);
    private Component title = Component.translatable((String)"gsscs.guide_book.view.title");
    private Component text = Component.translatable((String)"gsscs.guide_book.view.text");

    public SymbolBookScreen() {
        super((Component)Component.translatable((String)"gsscs.guide_book.view.title"));
    }

    protected void init() {
        int start = (this.width - 192) / 2;
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(start + 116, 174, true, this::nextPage, true));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(start + 43, 174, false, this::previousPage, true));
        this.setPage(0);
    }

    private void previousPage(@Nullable Button button) {
        this.setPage(this.currentPage - 1);
    }

    private void nextPage(@Nullable Button button) {
        this.setPage(this.currentPage + 1);
    }

    private void setPage(int page) {
        if (page < 0 || page > this.symbols.size()) {
            return;
        }
        this.currentPage = page;
        this.blankPage();
        int start = (this.width - 192) / 2 + 42;
        if (page != 0) {
            Iterator<String> symbolSet = this.symbols.keySet().iterator();
            this.currentSymbol = symbolSet.next();
            for (int i = 0; i < page - 1; ++i) {
                this.currentSymbol = symbolSet.next();
            }
            this.addPageVidget(new SymbolDrawboard(start, 47, 108, 108, this.symbols.get(this.currentSymbol)));
            AbstractSymbol abstractSymbol = this.symbols.get(this.currentSymbol);
            Objects.requireNonNull(abstractSymbol);
            AbstractSymbol abstractSymbol2 = abstractSymbol;
            int n = 0;
            String key = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormSymbol.class, AffectSymbol.class, ElementSymbol.class}, (Object)abstractSymbol2, n)) {
                case 0 -> {
                    FormSymbol symbol = (FormSymbol)abstractSymbol2;
                    yield "gsscs.guide_book.view.form_symbol";
                }
                case 1 -> {
                    AffectSymbol symbol = (AffectSymbol)abstractSymbol2;
                    yield "gsscs.guide_book.view.affect_symbol";
                }
                case 2 -> {
                    ElementSymbol symbol = (ElementSymbol)abstractSymbol2;
                    yield "gsscs.guide_book.view.elment_symbol";
                }
                default -> "gsscs.guide_book.view.symbol";
            };
            this.addPageVidget((AbstractWidget)new MultiLineTextWidget(start, 17, (Component)Component.translatable((String)key, (Object[])new Object[]{this.currentSymbol}).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"gsscs.guide_book.view.distance", (Object[])new Object[]{Float.toString(this.distance.floatValue())})), this.font).setMaxWidth(108).setMaxRows(3));
        } else {
            this.currentSymbol = "";
        }
        this.updatePageButtons();
    }

    private void updatePageButtons() {
        this.backButton.visible = this.currentPage > 0;
        this.forwardButton.visible = this.currentPage < this.symbols.size();
    }

    private void blankPage() {
        this.distance = Float.valueOf(Float.MAX_VALUE);
        this.pageWidgets.forEach(widget -> {
            if (widget instanceof SymbolDrawboard) {
                SymbolDrawboard drawboard = (SymbolDrawboard)((Object)widget);
                if (drawboard.background != null) {
                    drawboard.background.close();
                }
                if (drawboard.drawn != null) {
                    drawboard.drawn.close();
                }
            }
        });
        this.pageWidgets.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.pageWidgets.clear();
    }

    private void addPageVidget(AbstractWidget widget) {
        this.pageWidgets.add(widget);
        this.addRenderableWidget((GuiEventListener)widget);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int start = (this.width - 192) / 2 + 42;
        if (this.currentPage == 0) {
            FormattedCharSequence seq;
            int i;
            int top = 17;
            List formated = this.font.split((FormattedText)this.title, 108);
            for (i = 0; i < formated.size(); ++i) {
                seq = (FormattedCharSequence)formated.get(i);
                guiGraphics.drawString(this.font, seq, start + 54 - this.font.width(seq) / 2, top, -16777216, false);
                top += 9;
            }
            top += 9;
            formated = this.font.split((FormattedText)this.text, 108);
            for (i = 0; i < formated.size(); ++i) {
                seq = (FormattedCharSequence)formated.get(i);
                guiGraphics.drawString(this.font, seq, start, top, -16777216, false);
                top += 9;
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_LOCATION, (this.width - 192) / 2, 2, 0.0f, 0.0f, 192, 192, 256, 256);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        for (AbstractWidget widget : this.pageWidgets) {
            SymbolDrawboard drawboard;
            if (event.button() == 0) {
                AbstractSymbol abstractSymbol;
                if (widget instanceof SymbolDrawboard) {
                    drawboard = (SymbolDrawboard)widget;
                    try {
                        this.distance = Float.valueOf(GSSCS.getIdentifier().distance(new Recognizer.Gesture((Recognizer.Point[])drawboard.points.toArray(Recognizer.Point[]::new)), drawboard.symbol.getGesture()));
                        if (drawboard.symbol instanceof FormSymbol) {
                            if (!(this.distance.floatValue() < 8.0f)) continue;
                            drawboard.recongised((Recognizer.Point[])drawboard.points.toArray(Recognizer.Point[]::new));
                            continue;
                        }
                        if (!(this.distance.floatValue() < 16.0f)) continue;
                        drawboard.recongised((Recognizer.Point[])drawboard.points.toArray(Recognizer.Point[]::new));
                    }
                    catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {}
                    continue;
                }
                if (!(widget instanceof MultiLineTextWidget)) continue;
                MultiLineTextWidget stringWidget = (MultiLineTextWidget)widget;
                Objects.requireNonNull(this.symbols.get(this.currentSymbol));
                int n = 0;
                String key = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormSymbol.class, AffectSymbol.class, ElementSymbol.class}, (Object)abstractSymbol, n)) {
                    case 0 -> {
                        FormSymbol symbol = (FormSymbol)abstractSymbol;
                        yield "gsscs.guide_book.view.form_symbol";
                    }
                    case 1 -> {
                        AffectSymbol symbol = (AffectSymbol)abstractSymbol;
                        yield "gsscs.guide_book.view.affect_symbol";
                    }
                    case 2 -> {
                        ElementSymbol symbol = (ElementSymbol)abstractSymbol;
                        yield "gsscs.guide_book.view.element_symbol";
                    }
                    default -> "gsscs.guide_book.view.symbol";
                };
                stringWidget.setMessage((Component)Component.translatable((String)key, (Object[])new Object[]{this.currentSymbol}).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"gsscs.guide_book.view.distance", (Object[])new Object[]{Float.toString(this.distance.floatValue())})));
                continue;
            }
            if (event.button() != 1 || !(widget instanceof SymbolDrawboard)) continue;
            drawboard = (SymbolDrawboard)widget;
            drawboard.clearInput();
        }
        return super.mouseReleased(event);
    }

    private static class SymbolDrawboard
    extends AbstractWidget {
        private final AbstractSymbol symbol;
        private DynamicTexture background;
        private DynamicTexture drawn;
        private ArrayList<Recognizer.Point> points = new ArrayList();
        private int lastStoke = -1;

        public SymbolDrawboard(int x, int y, int width, int height, AbstractSymbol symbol) {
            super(x, y, width, height, CommonComponents.EMPTY);
            this.symbol = symbol;
            this.drawn = new DynamicTexture("guide_input_texture", width, height, true);
            this.drawn.upload();
            this.background = new DynamicTexture("guide_background_texture", width, height, true);
            NativeImage pixels = this.background.getPixels();
            pixels.fillRect(0, 0, width, height, 790239770);
            Recognizer.Point[] points = symbol.getGesture().getPoints();
            for (int i = 0; i < points.length; i += 2) {
                DrawingUtil.line(pixels, 1 + (int)((points[i].getX() + 0.5f) * (float)(width - 2)), 1 + (int)((points[i].getY() + 0.5f) * (float)(height - 2)), 1 + (int)((points[i + 1].getX() + 0.5f) * (float)(width - 2)), 1 + (int)((points[i + 1].getY() + 0.5f) * (float)(height - 2)), -1878390262, true);
            }
            this.background.upload();
        }

        public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
            if (event.button() == 0 && event.x() - mouseX >= (double)this.getX() && event.x() - mouseX < (double)(this.getX() + this.width) && event.y() - mouseY >= (double)this.getY() && event.y() - mouseY < (double)(this.getY() + this.height)) {
                float xRel = (float)((event.x() - (double)this.getX()) / (double)this.width);
                float yRel = (float)((event.y() - (double)this.getY()) / (double)this.height);
                float xPrevRel = (float)((event.x() - (double)this.getX() - mouseX) / (double)this.width);
                float yPrevRel = (float)((event.y() - (double)this.getY() - mouseY) / (double)this.height);
                int tWidth = this.drawn.getPixels().getWidth();
                int tHeight = this.drawn.getPixels().getHeight();
                int x0 = (int)(xPrevRel * (float)tWidth);
                int x1 = (int)(xRel * (float)tWidth);
                int y0 = (int)(yPrevRel * (float)tHeight);
                int y1 = (int)(yRel * (float)tHeight);
                this.points.add(new Recognizer.Point(x0, y0, ++this.lastStoke));
                this.points.add(new Recognizer.Point(x1, y1, this.lastStoke));
                DrawingUtil.line(this.drawn.getPixels(), x0, y0, x1, y1, -16776961, true);
                this.drawn.upload();
                return true;
            }
            return super.mouseDragged(event, mouseX, mouseY);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            ((GuiGraphicsInvoker)guiGraphics).invokeSubmitBlit(RenderPipelines.GUI_TEXTURED, this.background.getTextureView(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0.0f, 1.0f, 0.0f, 1.0f, -1);
            ((GuiGraphicsInvoker)guiGraphics).invokeSubmitBlit(RenderPipelines.GUI_TEXTURED, this.drawn.getTextureView(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0.0f, 1.0f, 0.0f, 1.0f, -1);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void recongised(Recognizer.Point[] points) {
            this.points = new ArrayList();
            NativeImage pixels = this.drawn.getPixels();
            for (int i = 0; i < points.length; i += 2) {
                DrawingUtil.line(pixels, (int)points[i].getX(), (int)points[i].getY(), (int)points[i + 1].getX(), (int)points[i + 1].getY(), -16777216, true);
            }
            this.drawn.upload();
        }

        private void clearInput() {
            this.points = new ArrayList();
            NativeImage pixels = this.drawn.getPixels();
            pixels.fillRect(0, 0, pixels.getWidth(), pixels.getHeight(), 0);
            this.drawn.upload();
        }
    }
}

