/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.network.packets.clientbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import ma.shaur.gsscs.spells.symbols.AbstractSymbol;
import ma.shaur.gsscs.spells.symbols.Recognizer;
import ma.shaur.gsscs.spells.symbols.SymbolStorage;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SpellListPaketPayload(SymbolStorage storage) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpellListPaketPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"gsscs", (String)"spell_list_packet"));
    public static final StreamCodec<ByteBuf, SpellListPaketPayload> STREAM_CODEC = new StreamCodec<ByteBuf, SpellListPaketPayload>(){

        public SpellListPaketPayload decode(ByteBuf buf) {
            LinkedHashMap<String, Recognizer.Gesture> gestures = new LinkedHashMap<String, Recognizer.Gesture>();
            int size = VarInt.read((ByteBuf)buf);
            for (int i = 0; i < size; ++i) {
                byte[] bytes = new byte[VarInt.read((ByteBuf)buf)];
                buf.readBytes(bytes);
                String name = new String(bytes, StandardCharsets.UTF_8);
                Recognizer.Point[] points = new Recognizer.Point[VarInt.read((ByteBuf)buf)];
                for (int j = 0; j < points.length; ++j) {
                    points[j] = new Recognizer.Point(buf.readFloat(), buf.readFloat(), j / 2);
                }
                gestures.put(name, new Recognizer.Gesture(points));
            }
            return new SpellListPaketPayload(new SymbolStorage(gestures));
        }

        public void encode(ByteBuf buf, SpellListPaketPayload packetPayload) {
            Iterator<Map.Entry<String, AbstractSymbol>> gestures = packetPayload.storage.symbols().entrySet().iterator();
            ByteBuf inner = Unpooled.buffer();
            int size = 0;
            while (gestures.hasNext()) {
                Map.Entry<String, AbstractSymbol> gesture = gestures.next();
                byte[] bytes = gesture.getKey().getBytes(StandardCharsets.UTF_8);
                VarInt.write((ByteBuf)inner, (int)bytes.length);
                inner.writeBytes(bytes);
                Recognizer.Point[] points = gesture.getValue().getGesture().getPoints();
                VarInt.write((ByteBuf)inner, (int)points.length);
                for (int j = 0; j < points.length; ++j) {
                    inner.writeFloat(points[j].getX());
                    inner.writeFloat(points[j].getY());
                }
                ++size;
            }
            VarInt.write((ByteBuf)buf, (int)size);
            buf.writeBytes(inner);
        }
    };

    public CustomPacketPayload.Type<? extends SpellListPaketPayload> type() {
        return TYPE;
    }
}

