/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.network.packets.serverbound;

import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.shaur.gsscs.GSSCS;
import ma.shaur.gsscs.network.packets.clientbound.CastEndPacketPayload;
import ma.shaur.gsscs.network.packets.clientbound.SymbolRecognisedPacketPyload;
import ma.shaur.gsscs.network.packets.serverbound.SpellCastEndPacketPayload;
import ma.shaur.gsscs.network.packets.serverbound.SpellPacketPayload;
import ma.shaur.gsscs.spells.Spell;
import ma.shaur.gsscs.spells.symbols.AbstractSymbol;
import ma.shaur.gsscs.spells.symbols.AffectSymbol;
import ma.shaur.gsscs.spells.symbols.ElementSymbol;
import ma.shaur.gsscs.spells.symbols.FormSymbol;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ServerNetworkHandler {
    private static Map<Player, Spell> SPELLS = new HashMap<Player, Spell>();
    private static List<Tickable> TICKABLES = new ArrayList<Tickable>();
    private static List<Tickable> TO_REMOVE_TICKABLES = new ArrayList<Tickable>();

    private static void tick(Player player) {
        for (Tickable tickable : TICKABLES) {
            tickable.tick(player);
        }
        TICKABLES.removeAll(TO_REMOVE_TICKABLES);
        TO_REMOVE_TICKABLES.clear();
    }

    public static void spellPacketReceived(SpellPacketPayload payload, NetworkManager.PacketContext context) {
        Spell spell2;
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        if (SPELLS.get(player) == null) {
            SPELLS.put((Player)player, new Spell((LivingEntity)player, null, spell -> spell, -1, new Entity[]{null}));
        }
        if ((spell2 = SPELLS.get(player)).objectType() == Spell.ObjectType.INVALID) {
            FormSymbol symbol = GSSCS.getIdentifier().identifyForm(payload.points());
            boolean recognised = symbol != null;
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SymbolRecognisedPacketPyload(recognised));
            if (recognised) {
                SPELLS.put((Player)player, spell2.object(symbol));
                player.level().playSound(null, (Entity)player, SoundEvents.ANVIL_LAND, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        } else {
            AbstractSymbol symbol = GSSCS.getIdentifier().identifyAffectOrElement(payload.points());
            boolean recognised = symbol != null;
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SymbolRecognisedPacketPyload(recognised));
            if (recognised) {
                if (symbol instanceof AffectSymbol) {
                    SPELLS.put((Player)player, spell2.affect(symbol));
                    player.level().playSound(null, (Entity)player, SoundEvents.ANVIL_LAND, SoundSource.PLAYERS, 0.5f, 1.0f);
                } else if (symbol instanceof ElementSymbol) {
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CastEndPacketPayload(CastEndPacketPayload.Reason.SUCCESS));
                    ServerNetworkHandler.castSpell(player, spell2, (ElementSymbol)symbol);
                }
            }
        }
    }

    public static void spellCastEndPacketReceived(SpellCastEndPacketPayload payload, NetworkManager.PacketContext context) {
        Spell spell;
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        if (!payload.cast()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CastEndPacketPayload(CastEndPacketPayload.Reason.SYMBOLS_CONNECTED));
            ServerNetworkHandler.invalidSpell(player);
        }
        if ((spell = SPELLS.get(player)) != null) {
            ServerNetworkHandler.castSpell(player, spell, null);
        }
    }

    private static void castSpell(ServerPlayer player, Spell spell, @Nullable ElementSymbol elementSymbol) {
        player.level().playSound(null, (Entity)player, SoundEvents.EVOKER_PREPARE_ATTACK, SoundSource.PLAYERS, 0.5f, 1.0f);
        if (spell.objectType() == Spell.ObjectType.INVALID) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CastEndPacketPayload(CastEndPacketPayload.Reason.NO_SPELL));
            ServerNetworkHandler.invalidSpell(player);
            SPELLS.put((Player)player, null);
            return;
        }
        int mutations = spell.mutations();
        if (mutations > 20 || mutations > 3 && (double)(player.level().random.nextFloat() * 100.0f) < Math.pow(mutations, 1.353984985057691)) {
            ServerNetworkHandler.consume(player);
            SPELLS.put((Player)player, null);
            return;
        }
        TICKABLES.add(new SpellCooldownAwaiter(spell, elementSymbol, player));
        SPELLS.put((Player)player, null);
    }

    private static void consume(ServerPlayer player) {
        player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, -1, 255, false, false, false));
        player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, -1, 255, false, false, false));
        player.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(-1.0);
        player.getAttribute(Attributes.ATTACK_SPEED).setBaseValue(0.0);
        player.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(0.0);
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"gsscs.message.void.loud")));
        TICKABLES.add(new VoidConsumeAwaiter(player));
    }

    private static void invalidSpell(ServerPlayer player) {
        player.level().playSound(null, (Entity)player, SoundEvents.ELDER_GUARDIAN_CURSE, SoundSource.PLAYERS, 0.5f, 1.0f);
        player.level().sendParticles((ParticleOptions)ParticleTypes.ENCHANT, player.getX(), player.getEyeY(), player.getZ(), 50, 1.0, 2.0, 1.0, 2.0);
        player.level().sendParticles((ParticleOptions)new DustColorTransitionOptions(10116294, 0xFFFFFF, 1.0f), player.getX(), player.getEyeY(), player.getZ(), 50, 1.0, 2.0, 1.0, -2.0);
    }

    static {
        TickEvent.PLAYER_POST.register(ServerNetworkHandler::tick);
    }

    private static interface Tickable {
        public void tick(Player var1);

        default public void remove() {
            TO_REMOVE_TICKABLES.add(this);
        }
    }

    private static class SpellCooldownAwaiter
    implements Tickable {
        private final Spell spell;
        private final ElementSymbol elementSymbol;
        private final ServerPlayer player;
        private int tick = 0;

        public SpellCooldownAwaiter(Spell spell, ElementSymbol elementSymbol, ServerPlayer player) {
            this.spell = spell;
            this.elementSymbol = elementSymbol;
            this.player = player;
        }

        @Override
        public void tick(Player p) {
            ServerPlayer player;
            if (!(p instanceof ServerPlayer) || !(player = (ServerPlayer)p).equals((Object)this.player)) {
                return;
            }
            if (this.tick == 20) {
                p.level().playSound(null, (Entity)p, SoundEvents.EVOKER_PREPARE_ATTACK, SoundSource.PLAYERS, 0.5f, 1.0f);
                this.spell.cast(this.elementSymbol == null ? ElementSymbol.NONE : this.elementSymbol);
                player.hasImpulse = true;
                this.remove();
                return;
            }
            ++this.tick;
        }
    }

    private static class VoidConsumeAwaiter
    implements Tickable {
        private int tick = 0;
        private final ServerPlayer player;

        public VoidConsumeAwaiter(ServerPlayer player) {
            this.player = player;
        }

        @Override
        public void tick(Player p) {
            ServerPlayer player;
            if (!(p instanceof ServerPlayer) || !(player = (ServerPlayer)p).equals((Object)this.player)) {
                return;
            }
            if (this.tick == 30) {
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"gsscs.message.void.silence")));
                player.level().playSound(null, (Entity)player, SoundEvents.WARDEN_ROAR, SoundSource.MASTER, 0.1f, 0.1f);
                player.teleportTo(player.getX(), -32768.0, player.getZ());
                player.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.1);
                player.getAttribute(Attributes.ATTACK_SPEED).setBaseValue(((Attribute)Attributes.ATTACK_SPEED.value()).getDefaultValue());
                player.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(((Attribute)Attributes.JUMP_STRENGTH.value()).getDefaultValue());
                this.remove();
                return;
            }
            ++this.tick;
        }
    }
}

