/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.network.packets.serverbound;

import io.netty.buffer.ByteBuf;
import ma.shaur.gsscs.spells.symbols.Recognizer;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SpellPacketPayload(Recognizer.Point[] points) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpellPacketPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"gsscs", (String)"spell_packet"));
    public static final StreamCodec<ByteBuf, SpellPacketPayload> STREAM_CODEC = new SpellPacketPayloadCodec();

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class SpellPacketPayloadCodec
    implements StreamCodec<ByteBuf, SpellPacketPayload> {
        public SpellPacketPayload decode(ByteBuf buf) {
            Recognizer.Point[] points = new Recognizer.Point[VarInt.read((ByteBuf)buf)];
            for (int i = 0; i < points.length; ++i) {
                points[i] = new Recognizer.Point(buf.readFloat(), buf.readFloat(), buf.readInt());
            }
            return new SpellPacketPayload(points);
        }

        public void encode(ByteBuf buf, SpellPacketPayload packetPayload) {
            VarInt.write((ByteBuf)buf, (int)packetPayload.points.length);
            for (Recognizer.Point point : packetPayload.points) {
                buf.writeFloat(point.getX());
                buf.writeFloat(point.getY());
                buf.writeInt(point.getStrokeID());
            }
        }
    }
}

