/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.spells;

import java.util.function.Function;
import ma.shaur.gsscs.spells.symbols.ElementSymbol;
import ma.shaur.gsscs.spells.symbols.FormSymbol;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record Spell(LivingEntity caster, FormSymbol formSymbol, Function<Spell, Spell> affects, int mutations, @Nullable Entity[] spell) {
    public Spell object(FormSymbol formSymbol) {
        return new Spell(this.caster, formSymbol, this.affects, 1 + this.mutations, this.spell);
    }

    public Spell affect(Function<Spell, Spell> affect) {
        return new Spell(this.caster, this.formSymbol, this.affects.andThen(affect), 1 + this.mutations, this.spell);
    }

    public Spell withSpell(Entity ... spell) {
        return new Spell(this.caster, this.formSymbol, this.affects, this.mutations, spell);
    }

    public void cast(ElementSymbol element) {
        Spell affected = this.affects.compose(element).compose(this.formSymbol).apply(this);
        if (affected.objectType() != ObjectType.CASTER) {
            for (Entity entity : affected.spell) {
                this.caster.level().addFreshEntity(entity);
            }
        }
    }

    public ObjectType objectType() {
        return this.formSymbol == null ? ObjectType.INVALID : this.formSymbol.objectType();
    }

    public static enum ObjectType {
        INVALID(null),
        CASTER(caster -> caster),
        SMALL_PROJ(caster -> ObjectType.initVelocity(caster, (Projectile)new Arrow(caster.level(), caster, ItemStack.EMPTY, null))),
        LARGE_PROJ(caster -> ObjectType.initVelocity(caster, (Projectile)new ThrownTrident(caster.level(), caster, ItemStack.EMPTY))),
        BLOCK(null);

        private final EntityFactory<? extends Entity> defaultMaker;

        private ObjectType(EntityFactory<? extends Entity> defaultMaker) {
            this.defaultMaker = defaultMaker;
        }

        public Entity createEntity(LivingEntity caster) {
            return this.defaultMaker == null ? null : this.defaultMaker.create(caster);
        }

        private static Entity initVelocity(LivingEntity caster, Projectile projectile) {
            Vec3 look = Vec3.directionFromRotation((float)caster.getXRot(), (float)caster.getYRot());
            projectile.setXRot(caster.getXRot());
            projectile.setYRot(caster.getYRot());
            projectile.setDeltaMovement(look.multiply(3.0, 3.0, 3.0));
            return projectile;
        }
    }

    private static interface EntityFactory<T extends Entity> {
        public T create(LivingEntity var1);
    }
}

