/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.spells.symbols;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ma.shaur.gsscs.mixin.LargeFireballAccessor;
import ma.shaur.gsscs.spells.Spell;
import ma.shaur.gsscs.spells.symbols.AbstractSymbol;
import ma.shaur.gsscs.spells.symbols.AffectSymbol;
import ma.shaur.gsscs.spells.symbols.ElementSymbol;
import ma.shaur.gsscs.spells.symbols.FormSymbol;
import ma.shaur.gsscs.spells.symbols.Recognizer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class SymbolStorage {
    private static Predicate<AbstractSymbol> FORM_SYMBOLS = symbol -> symbol instanceof FormSymbol;
    private static Predicate<AbstractSymbol> AFFECT_SYMBOLS = symbol -> symbol instanceof AffectSymbol;
    private static Predicate<AbstractSymbol> ELEMENT_SYMBOLS = symbol -> symbol instanceof ElementSymbol;
    private Map<String, AbstractSymbol> symbols = new LinkedHashMap<String, AbstractSymbol>();

    public SymbolStorage(Map<String, Recognizer.Gesture> gestures) {
        this.symbols.put("self", new FormSymbol(null, Spell.ObjectType.CASTER));
        this.symbols.put("smallProj", new FormSymbol(null, Spell.ObjectType.SMALL_PROJ));
        this.symbols.put("largeProj", new FormSymbol(null, Spell.ObjectType.LARGE_PROJ));
        this.symbols.put("fast", new AffectSymbol(null, spell -> {
            LivingEntity caster = spell.caster();
            caster.getActiveEffects().forEach(effect -> effect.update(effect.withScaledDuration(0.75f)));
            if (caster.isOnFire()) {
                caster.setRemainingFireTicks((int)((float)caster.getRemainingFireTicks() * 0.75f));
            }
            return spell;
        }, spell -> {
            for (Entity entity : spell.spell()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(2.0, 2.0, 2.0));
            }
            return spell;
        }, spell -> {
            int length = spell.spell().length;
            if (spell.caster().isAutoSpinAttack()) {
                spell.caster().addDeltaMovement(Vec3.directionFromRotation((Vec2)spell.caster().getRotationVector()));
            }
            System.out.println(spell.caster().isAutoSpinAttack());
            System.out.println(spell.caster().getDeltaMovement());
            if (length == 0) {
                return spell;
            }
            Entity center = spell.spell()[length / 2];
            if (center instanceof ThrownSplashPotion) {
                ThrownSplashPotion centerPotion = (ThrownSplashPotion)center;
                ArrayList amplified = new ArrayList();
                ((PotionContents)centerPotion.getItem().get(DataComponents.POTION_CONTENTS)).forEachEffect(effect -> amplified.add(effect), 0.75f);
                for (Entity e : spell.spell()) {
                    if (!(e instanceof ThrownSplashPotion)) continue;
                    ThrownSplashPotion potion = (ThrownSplashPotion)e;
                    potion.getItem().set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), amplified, Optional.empty()));
                }
                return spell;
            }
            for (Entity entity : spell.spell()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(2.0, 2.0, 2.0));
            }
            return spell;
        }));
        this.symbols.put("slow", new AffectSymbol(null, spell -> {
            LivingEntity caster = spell.caster();
            caster.getActiveEffects().forEach(effect -> caster.addEffect(effect.withScaledDuration(1.5f)));
            if (caster.isOnFire()) {
                caster.setRemainingFireTicks((int)((float)caster.getRemainingFireTicks() * 1.5f));
            }
            if (caster.isAutoSpinAttack()) {
                caster.setDeltaMovement(caster.getDeltaMovement().multiply(0.75, 0.75, 0.75));
            }
            return spell;
        }, spell -> {
            for (Entity entity : spell.spell()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.5, 0.5, 0.5));
            }
            return spell;
        }, spell -> {
            int length = spell.spell().length;
            if (spell.caster().isAutoSpinAttack()) {
                spell.caster().addDeltaMovement(Vec3.directionFromRotation((Vec2)spell.caster().getRotationVector()));
            }
            System.out.println(spell.caster().isAutoSpinAttack());
            System.out.println(spell.caster().getDeltaMovement());
            if (length == 0) {
                return spell;
            }
            Entity center = spell.spell()[length / 2];
            if (center instanceof ThrownSplashPotion) {
                ThrownSplashPotion centerPotion = (ThrownSplashPotion)center;
                ArrayList amplified = new ArrayList();
                ((PotionContents)centerPotion.getItem().get(DataComponents.POTION_CONTENTS)).forEachEffect(effect -> amplified.add(effect), 1.5f);
                for (Entity e : spell.spell()) {
                    if (!(e instanceof ThrownSplashPotion)) continue;
                    ThrownSplashPotion potion = (ThrownSplashPotion)e;
                    potion.getItem().set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), amplified, Optional.empty()));
                }
                return spell;
            }
            for (Entity entity : spell.spell()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.5, 0.5, 0.5));
            }
            return spell;
        }));
        this.symbols.put("multiply", new AffectSymbol(null, spell -> {
            for (MobEffectInstance effect : spell.caster().getActiveEffects()) {
                effect.update(new MobEffectInstance(effect.getEffect(), effect.getDuration(), effect.getAmplifier() + 1, effect.isAmbient(), effect.isVisible(), effect.showIcon()));
            }
            return spell;
        }, spell -> SymbolStorage.multiplyGeneric(spell), spell -> {
            int length = spell.spell().length;
            Entity entity = spell.spell()[length / 2];
            if (entity instanceof ThrownSplashPotion) {
                ThrownSplashPotion centerPotion = (ThrownSplashPotion)entity;
                ArrayList amplified = new ArrayList();
                ((PotionContents)centerPotion.getItem().get(DataComponents.POTION_CONTENTS)).forEachEffect(effect -> amplified.add(new MobEffectInstance(effect.getEffect(), effect.getDuration(), effect.getAmplifier() + 1, effect.isAmbient(), effect.isVisible(), effect.showIcon())), 1.0f);
                for (Entity e : spell.spell()) {
                    if (!(e instanceof ThrownSplashPotion)) continue;
                    ThrownSplashPotion potion = (ThrownSplashPotion)e;
                    potion.getItem().set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), amplified, Optional.empty()));
                }
                return spell;
            }
            if (entity instanceof LargeFireball) {
                for (Entity e : spell.spell()) {
                    if (!(e instanceof LargeFireballAccessor)) continue;
                    LargeFireballAccessor fireball = (LargeFireballAccessor)e;
                    fireball.explosionPower(fireball.explosionPower() + 1);
                }
                return spell;
            }
            if (entity instanceof BreezeWindCharge) {
                Entity[] entities = spell.spell();
                Entity[] newEntities = new Entity[(int)Math.ceil((double)entities.length * 1.5)];
                System.arraycopy(entities, 0, newEntities, 0, entities.length);
                for (int i = entities.length; i < newEntities.length; ++i) {
                    newEntities[i] = new BreezeWindCharge(EntityType.BREEZE_WIND_CHARGE, spell.caster().level());
                    ((Projectile)newEntities[i]).setOwner((Entity)spell.caster());
                    newEntities[i].teleportTo(entity.getX(), entity.getY(), entity.getZ());
                    newEntities[i].setDeltaMovement(entity.getDeltaMovement());
                }
                return spell.withSpell(newEntities);
            }
            return SymbolStorage.multiplyGeneric(spell);
        }));
        this.symbols.put("fire", new ElementSymbol(null, spell -> {
            switch (spell.objectType()) {
                case CASTER: {
                    spell.caster().igniteForTicks(200);
                    break;
                }
                case SMALL_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new SmallFireball(spell.spell()[i].level(), spell.caster(), Vec3.directionFromRotation((Vec2)spell.caster().getRotationVector()));
                        spell.spell()[i].teleportRelative(0.0, (double)spell.caster().getEyeHeight(), 0.0);
                    }
                    break;
                }
                case LARGE_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new LargeFireball(spell.spell()[i].level(), spell.caster(), Vec3.directionFromRotation((Vec2)spell.caster().getRotationVector()), 3);
                        spell.spell()[i].teleportRelative(0.0, (double)spell.caster().getEyeHeight(), 0.0);
                    }
                    break;
                }
            }
            return spell;
        }));
        this.symbols.put("water", new ElementSymbol(null, spell -> {
            switch (spell.objectType()) {
                case CASTER: {
                    Vec3 vec = spell.caster().getEyePosition();
                    spell.caster().level().setBlockAndUpdate(new BlockPos((int)vec.x, (int)vec.y, (int)vec.z), Blocks.WATER.defaultBlockState());
                    break;
                }
                case SMALL_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        Vec3 momentum = spell.spell()[i].getDeltaMovement();
                        Vec3 vec3 = spell.spell()[i].position();
                        spell.spell()[i] = new LlamaSpit(EntityType.LLAMA_SPIT, spell.caster().level());
                        ((Projectile)spell.spell()[i]).setOwner((Entity)spell.caster());
                        spell.spell()[i].teleportTo(vec3.x, vec3.y, vec3.z);
                        spell.spell()[i].setDeltaMovement(momentum);
                    }
                    break;
                }
                case LARGE_PROJ: {
                    LivingEntity patt0$temp;
                    if (spell.caster().isInWaterOrRain() && (patt0$temp = spell.caster()) instanceof Player) {
                        Player player = (Player)patt0$temp;
                        player.push(Vec3.directionFromRotation((Vec2)player.getRotationVector()).multiply(10.0, 10.0, 10.0));
                        player.startAutoSpinAttack(20, 8.0f, player.getMainHandItem());
                        if (player.onGround()) {
                            player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                        }
                        player.level().playSound(null, (Entity)player, (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_1.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        System.out.println(spell.caster().isAutoSpinAttack());
                        System.out.println(spell.caster().getDeltaMovement());
                        System.out.println(spell.caster().hasImpulse);
                        return spell.withSpell(new Entity[0]);
                    }
                    ItemStack itemStack = new ItemStack((ItemLike)Items.SPLASH_POTION);
                    itemStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), new ArrayList(spell.caster().getActiveEffects()), Optional.empty()));
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new ThrownSplashPotion(spell.spell()[i].level(), spell.caster(), itemStack);
                        spell.spell()[i].setDeltaMovement(Vec3.directionFromRotation((Vec2)spell.caster().getRotationVector()));
                    }
                    break;
                }
            }
            return spell;
        }));
        this.symbols.put("wind", new ElementSymbol(null, spell -> {
            switch (spell.objectType()) {
                case CASTER: {
                    spell.caster().addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 600, 0));
                    spell.caster().addEffect(new MobEffectInstance(MobEffects.SPEED, 600, 0));
                    spell.caster().addEffect(new MobEffectInstance(MobEffects.JUMP_BOOST, 600, 0));
                    break;
                }
                case SMALL_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        Vec3 momentum = spell.spell()[i].getDeltaMovement();
                        Vec3 vec3 = spell.spell()[i].position();
                        spell.spell()[i] = new WindCharge(spell.spell()[i].level(), vec3.x, vec3.y, vec3.z, Vec3.directionFromRotation((Vec2)spell.caster().getRotationVector()));
                        ((Projectile)spell.spell()[i]).setOwner((Entity)spell.caster());
                        spell.spell()[i].setDeltaMovement(momentum);
                    }
                    break;
                }
                case LARGE_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        Vec3 vec3 = spell.spell()[i].position();
                        Vec3 momentum = spell.spell()[i].getDeltaMovement();
                        spell.spell()[i] = new BreezeWindCharge(EntityType.BREEZE_WIND_CHARGE, spell.caster().level());
                        ((Projectile)spell.spell()[i]).setOwner((Entity)spell.caster());
                        spell.spell()[i].teleportTo(vec3.x, vec3.y, vec3.z);
                        spell.spell()[i].setDeltaMovement(momentum);
                    }
                    break;
                }
            }
            return spell;
        }));
        this.symbols.put("end", new ElementSymbol(null, spell -> {
            block0 : switch (spell.objectType()) {
                case CASTER: {
                    LivingEntity caster = spell.caster();
                    for (int i = 0; i < 16; ++i) {
                        SoundSource soundSource;
                        SoundEvent soundEvent;
                        double x = caster.getX() + (caster.getRandom().nextDouble() - 0.5) * 16.0;
                        double y = Mth.clamp((double)(caster.getY() + (caster.getRandom().nextDouble() - 0.5) * 16.0), (double)caster.level().getMinY(), (double)(caster.level().getMinY() + ((ServerLevel)caster.level()).getLogicalHeight() - 1));
                        double z = caster.getZ() + (caster.getRandom().nextDouble() - 0.5) * 16.0;
                        if (caster.isPassenger()) {
                            caster.stopRiding();
                        }
                        Vec3 vec3 = caster.position();
                        if (!caster.randomTeleport(x, y, z, true)) continue;
                        caster.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)caster));
                        if (caster instanceof Fox) {
                            soundEvent = SoundEvents.FOX_TELEPORT;
                            soundSource = SoundSource.NEUTRAL;
                        } else {
                            soundEvent = SoundEvents.CHORUS_FRUIT_TELEPORT;
                            soundSource = SoundSource.PLAYERS;
                        }
                        caster.level().playSound(null, caster.getX(), caster.getY(), caster.getZ(), soundEvent, soundSource);
                        caster.resetFallDistance();
                        break block0;
                    }
                    break;
                }
                case SMALL_PROJ: {
                    Entity target = null;
                    double minDist = Double.MAX_VALUE;
                    for (Entity entity : spell.caster().level().getEntitiesOfClass(LivingEntity.class, spell.caster().getBoundingBox().expandTowards(Vec3.directionFromRotation((Vec2)spell.caster().getRotationVector()).multiply(64.0, 64.0, 64.0)))) {
                        double dist;
                        if (spell.caster() == entity || !spell.caster().hasLineOfSight(entity) || !((dist = spell.caster().position().distanceToSqr(entity.position())) < minDist)) continue;
                        target = entity;
                        minDist = dist;
                    }
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new ShulkerBullet(spell.spell()[i].level(), spell.caster(), target, spell.caster().getDirection().getAxis());
                    }
                    break;
                }
                case LARGE_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new DragonFireball(spell.spell()[i].level(), spell.caster(), Vec3.directionFromRotation((Vec2)spell.caster().getRotationVector()));
                    }
                    break;
                }
            }
            return spell;
        }));
        if (gestures != null) {
            this.gestures(gestures);
        }
    }

    private static Spell multiplyGeneric(Spell spell) {
        int i;
        int length = spell.spell().length;
        Entity entity = spell.spell()[length / 2];
        ProblemReporter.Collector collector = new ProblemReporter.Collector();
        TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)collector);
        entity.save((ValueOutput)output);
        output.store("pickup", AbstractArrow.Pickup.LEGACY_CODEC, (Object)AbstractArrow.Pickup.DISALLOWED);
        ValueInput input = TagValueInput.create((ProblemReporter)collector, (HolderLookup.Provider)entity.level().registryAccess(), (CompoundTag)output.buildResult());
        if (length == 1) {
            Entity copy1 = (Entity)EntityType.create((ValueInput)input, (Level)entity.level(), (EntitySpawnReason)EntitySpawnReason.EVENT).get();
            Entity copy2 = (Entity)EntityType.create((ValueInput)input, (Level)entity.level(), (EntitySpawnReason)EntitySpawnReason.EVENT).get();
            copy1.setDeltaMovement(entity.getDeltaMovement());
            copy2.setDeltaMovement(entity.getDeltaMovement());
            copy1.setUUID(Mth.createInsecureUUID((RandomSource)copy1.getRandom()));
            copy2.setUUID(Mth.createInsecureUUID((RandomSource)copy2.getRandom()));
            Vec3 horizontal = Vec3.directionFromRotation((float)0.0f, (float)(entity.getYRot() + 90.0f));
            copy1.teleportRelative(horizontal.x, horizontal.y, horizontal.z);
            copy2.teleportRelative(-horizontal.x, -horizontal.y, -horizontal.z);
            return spell.withSpell(copy1, entity, copy2);
        }
        if (length == 3) {
            Entity[] entities = new Entity[9];
            for (int i2 = 0; i2 < 3; ++i2) {
                entities[i2] = (Entity)EntityType.create((ValueInput)input, (Level)entity.level(), (EntitySpawnReason)EntitySpawnReason.EVENT).get();
                entities[i2 + 3] = spell.spell()[i2];
                entities[i2 + 6] = (Entity)EntityType.create((ValueInput)input, (Level)entity.level(), (EntitySpawnReason)EntitySpawnReason.EVENT).get();
                entities[i2].setDeltaMovement(entity.getDeltaMovement());
                entities[i2 + 6].setDeltaMovement(entity.getDeltaMovement());
                entities[i2].setUUID(Mth.createInsecureUUID((RandomSource)entities[i2].getRandom()));
                entities[i2 + 6].setUUID(Mth.createInsecureUUID((RandomSource)entities[i2 + 6].getRandom()));
                Vec3 horizontal = Vec3.directionFromRotation((float)0.0f, (float)(entity.getYRot() + 90.0f));
                horizontal = horizontal.multiply((double)(i2 - 1), (double)(i2 - 1), (double)(i2 - 1));
                Vec3 vertical = Vec3.directionFromRotation((float)(entity.getXRot() + 90.0f), (float)entity.getYRot());
                entities[i2].teleportRelative(vertical.x + horizontal.x, vertical.y + horizontal.y, vertical.z + horizontal.z);
                entities[i2 + 6].teleportRelative(-vertical.x + horizontal.x, -vertical.y + horizontal.y, -vertical.z + horizontal.z);
            }
            return spell.withSpell(entities);
        }
        int sqrt = (int)Math.sqrt(length);
        int newSide = sqrt + 2;
        int halfSide = newSide / 2;
        Entity[] entities = new Entity[newSide * newSide];
        int padding = (entities.length - length) / 2;
        int halfPadding = padding / 2;
        System.arraycopy(spell.spell(), 0, entities, padding, length);
        Vec3 horizontal = Vec3.directionFromRotation((float)0.0f, (float)(entity.getYRot() + 90.0f));
        Vec3 vertical = Vec3.directionFromRotation((float)(entity.getXRot() + 90.0f), (float)entity.getYRot());
        Vec3 shift = Vec3.ZERO.add(horizontal.multiply((double)halfSide, (double)halfSide, (double)halfSide)).add(vertical.multiply((double)halfSide, (double)halfSide, (double)halfSide));
        horizontal = horizontal.multiply(-1.0, -1.0, -1.0);
        vertical = vertical.multiply(-1.0, -1.0, -1.0);
        for (i = 0; i < halfPadding; ++i) {
            entities[i] = (Entity)EntityType.create((ValueInput)input, (Level)entity.level(), (EntitySpawnReason)EntitySpawnReason.EVENT).get();
            entities[i].setDeltaMovement(entity.getDeltaMovement());
            entities[i].setUUID(Mth.createInsecureUUID((RandomSource)entities[0].getRandom()));
            entities[i].teleportRelative(shift.x, shift.y, shift.z);
            shift = shift.add(horizontal);
        }
        for (i = halfPadding; i < padding; ++i) {
            entities[i] = (Entity)EntityType.create((ValueInput)input, (Level)entity.level(), (EntitySpawnReason)EntitySpawnReason.EVENT).get();
            entities[i].setDeltaMovement(entity.getDeltaMovement());
            entities[i].setUUID(Mth.createInsecureUUID((RandomSource)entities[0].getRandom()));
            entities[i].teleportRelative(shift.x, shift.y, shift.z);
            shift = shift.add(vertical);
        }
        horizontal = horizontal.multiply(-1.0, -1.0, -1.0);
        vertical = vertical.multiply(-1.0, -1.0, -1.0);
        for (i = length + padding; i < entities.length - halfPadding; ++i) {
            entities[i] = (Entity)EntityType.create((ValueInput)input, (Level)entity.level(), (EntitySpawnReason)EntitySpawnReason.EVENT).get();
            entities[i].setDeltaMovement(entity.getDeltaMovement());
            entities[i].setUUID(Mth.createInsecureUUID((RandomSource)entities[0].getRandom()));
            entities[i].teleportRelative(shift.x, shift.y, shift.z);
            shift = shift.add(horizontal);
        }
        for (i = entities.length - halfPadding; i < entities.length; ++i) {
            entities[i] = (Entity)EntityType.create((ValueInput)input, (Level)entity.level(), (EntitySpawnReason)EntitySpawnReason.EVENT).get();
            entities[i].setDeltaMovement(entity.getDeltaMovement());
            entities[i].setUUID(Mth.createInsecureUUID((RandomSource)entities[0].getRandom()));
            entities[i].teleportRelative(shift.x, shift.y, shift.z);
            shift = shift.add(vertical);
        }
        return spell.withSpell(entities);
    }

    public void gestures(Map<String, Recognizer.Gesture> gestures) {
        for (String name : gestures.keySet()) {
            if (!this.symbols.containsKey(name)) continue;
            this.symbols.get(name).setGesture(gestures.get(name));
        }
    }

    public Map<String, Recognizer.Gesture> gestures() {
        return this.symbols.keySet().stream().collect(Collectors.toMap(name -> name, name -> this.symbols.get(name).getGesture()));
    }

    public AbstractSymbol symbol(String name) {
        return this.symbols.get(name);
    }

    public Map<String, AbstractSymbol> symbols() {
        return new LinkedHashMap<String, AbstractSymbol>(this.symbols);
    }

    public List<Map.Entry<String, AbstractSymbol>> formSymbols() {
        return this.symbols.entrySet().stream().filter(entry -> FORM_SYMBOLS.test((AbstractSymbol)entry.getValue())).collect(Collectors.toList());
    }

    public List<Map.Entry<String, AbstractSymbol>> affectAndElementSymbols() {
        return this.symbols.entrySet().stream().filter(entry -> AFFECT_SYMBOLS.or(ELEMENT_SYMBOLS).test((AbstractSymbol)entry.getValue())).collect(Collectors.toList());
    }
}

