/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import ma.shaur.gsscs.network.packets.clientbound.CastEndPacketPayload;
import ma.shaur.gsscs.network.packets.clientbound.ClientNetworkHandler;
import ma.shaur.gsscs.network.packets.clientbound.OpenGuideBookScreenPacketPayload;
import ma.shaur.gsscs.network.packets.clientbound.SpellListPaketPayload;
import ma.shaur.gsscs.network.packets.clientbound.SymbolRecognisedPacketPyload;
import ma.shaur.gsscs.network.packets.serverbound.ServerNetworkHandler;
import ma.shaur.gsscs.network.packets.serverbound.SpellCastEndPacketPayload;
import ma.shaur.gsscs.network.packets.serverbound.SpellPacketPayload;

public class NetworkRegistry {
    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SpellPacketPayload.TYPE, SpellPacketPayload.STREAM_CODEC, ServerNetworkHandler::spellPacketReceived);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SpellCastEndPacketPayload.TYPE, SpellCastEndPacketPayload.STREAM_CODEC, ServerNetworkHandler::spellCastEndPacketReceived);
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(CastEndPacketPayload.TYPE, CastEndPacketPayload.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(SymbolRecognisedPacketPyload.TYPE, SymbolRecognisedPacketPyload.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(SpellListPaketPayload.TYPE, SpellListPaketPayload.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(OpenGuideBookScreenPacketPayload.TYPE, OpenGuideBookScreenPacketPayload.STREAM_CODEC);
        } else {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CastEndPacketPayload.TYPE, CastEndPacketPayload.STREAM_CODEC, ClientNetworkHandler::castCancelPacketReceived);
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, SymbolRecognisedPacketPyload.TYPE, SymbolRecognisedPacketPyload.STREAM_CODEC, ClientNetworkHandler::symbolRecognisedPacketReceived);
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, SpellListPaketPayload.TYPE, SpellListPaketPayload.STREAM_CODEC, ClientNetworkHandler::spellListPacketReceived);
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, OpenGuideBookScreenPacketPayload.TYPE, OpenGuideBookScreenPacketPayload.STREAM_CODEC, ClientNetworkHandler::openGuideBookScreenPacketReceived);
        }
    }
}

