/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.network.packets.clientbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import ma.shaur.gsscs.spells.symbols.AbstractSymbol;
import ma.shaur.gsscs.spells.symbols.Recognizer;
import ma.shaur.gsscs.spells.symbols.SymbolStorage;
import net.minecraft.class_2960;
import net.minecraft.class_8703;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record SpellListPaketPayload(SymbolStorage storage) implements class_8710
{
    public static final class_8710.class_9154<SpellListPaketPayload> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"gsscs", (String)"spell_list_packet"));
    public static final class_9139<ByteBuf, SpellListPaketPayload> STREAM_CODEC = new class_9139<ByteBuf, SpellListPaketPayload>(){

        public SpellListPaketPayload decode(ByteBuf buf) {
            LinkedHashMap<String, Recognizer.Gesture> gestures = new LinkedHashMap<String, Recognizer.Gesture>();
            int size = class_8703.method_53016((ByteBuf)buf);
            for (int i = 0; i < size; ++i) {
                byte[] bytes = new byte[class_8703.method_53016((ByteBuf)buf)];
                buf.readBytes(bytes);
                String name = new String(bytes, StandardCharsets.UTF_8);
                Recognizer.Point[] points = new Recognizer.Point[class_8703.method_53016((ByteBuf)buf)];
                for (int j = 0; j < points.length; ++j) {
                    points[j] = new Recognizer.Point(buf.readFloat(), buf.readFloat(), j / 2);
                }
                gestures.put(name, new Recognizer.Gesture(points));
            }
            return new SpellListPaketPayload(new SymbolStorage(gestures));
        }

        public void encode(ByteBuf buf, SpellListPaketPayload packetPayload) {
            Iterator<Map.Entry<String, AbstractSymbol>> gestures = packetPayload.storage.symbols().entrySet().iterator();
            ByteBuf inner = Unpooled.buffer();
            int size = 0;
            while (gestures.hasNext()) {
                Map.Entry<String, AbstractSymbol> gesture = gestures.next();
                byte[] bytes = gesture.getKey().getBytes(StandardCharsets.UTF_8);
                class_8703.method_53017((ByteBuf)inner, (int)bytes.length);
                inner.writeBytes(bytes);
                Recognizer.Point[] points = gesture.getValue().getGesture().getPoints();
                class_8703.method_53017((ByteBuf)inner, (int)points.length);
                for (int j = 0; j < points.length; ++j) {
                    inner.writeFloat(points[j].getX());
                    inner.writeFloat(points[j].getY());
                }
                ++size;
            }
            class_8703.method_53017((ByteBuf)buf, (int)size);
            buf.writeBytes(inner);
        }
    };

    public class_8710.class_9154<? extends SpellListPaketPayload> method_56479() {
        return TYPE;
    }
}

