/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.network.packets.serverbound;

import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.shaur.gsscs.GSSCS;
import ma.shaur.gsscs.network.packets.clientbound.CastEndPacketPayload;
import ma.shaur.gsscs.network.packets.clientbound.SymbolRecognisedPacketPyload;
import ma.shaur.gsscs.network.packets.serverbound.SpellCastEndPacketPayload;
import ma.shaur.gsscs.network.packets.serverbound.SpellPacketPayload;
import ma.shaur.gsscs.spells.Spell;
import ma.shaur.gsscs.spells.symbols.AbstractSymbol;
import ma.shaur.gsscs.spells.symbols.AffectSymbol;
import ma.shaur.gsscs.spells.symbols.ElementSymbol;
import ma.shaur.gsscs.spells.symbols.FormSymbol;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_5743;
import net.minecraft.class_5894;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class ServerNetworkHandler {
    private static Map<class_1657, Spell> SPELLS = new HashMap<class_1657, Spell>();
    private static List<Tickable> TICKABLES = new ArrayList<Tickable>();
    private static List<Tickable> TO_REMOVE_TICKABLES = new ArrayList<Tickable>();

    private static void tick(class_1657 player) {
        for (Tickable tickable : TICKABLES) {
            tickable.tick(player);
        }
        TICKABLES.removeAll(TO_REMOVE_TICKABLES);
        TO_REMOVE_TICKABLES.clear();
    }

    public static void spellPacketReceived(SpellPacketPayload payload, NetworkManager.PacketContext context) {
        Spell spell2;
        class_3222 player = (class_3222)context.getPlayer();
        if (SPELLS.get(player) == null) {
            SPELLS.put((class_1657)player, new Spell((class_1309)player, null, spell -> spell, -1, new class_1297[]{null}));
        }
        if ((spell2 = SPELLS.get(player)).objectType() == Spell.ObjectType.INVALID) {
            FormSymbol symbol = GSSCS.getIdentifier().identifyForm(payload.points());
            boolean recognised = symbol != null;
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new SymbolRecognisedPacketPyload(recognised));
            if (recognised) {
                SPELLS.put((class_1657)player, spell2.object(symbol));
                player.method_51469().method_43129(null, (class_1297)player, class_3417.field_14833, class_3419.field_15248, 0.5f, 1.0f);
            }
        } else {
            AbstractSymbol symbol = GSSCS.getIdentifier().identifyAffectOrElement(payload.points());
            boolean recognised = symbol != null;
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new SymbolRecognisedPacketPyload(recognised));
            if (recognised) {
                if (symbol instanceof AffectSymbol) {
                    SPELLS.put((class_1657)player, spell2.affect(symbol));
                    player.method_51469().method_43129(null, (class_1297)player, class_3417.field_14833, class_3419.field_15248, 0.5f, 1.0f);
                } else if (symbol instanceof ElementSymbol) {
                    NetworkManager.sendToPlayer((class_3222)player, (class_8710)new CastEndPacketPayload(CastEndPacketPayload.Reason.SUCCESS));
                    ServerNetworkHandler.castSpell(player, spell2, (ElementSymbol)symbol);
                }
            }
        }
    }

    public static void spellCastEndPacketReceived(SpellCastEndPacketPayload payload, NetworkManager.PacketContext context) {
        Spell spell;
        class_3222 player = (class_3222)context.getPlayer();
        if (!payload.cast()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new CastEndPacketPayload(CastEndPacketPayload.Reason.SYMBOLS_CONNECTED));
            ServerNetworkHandler.invalidSpell(player);
        }
        if ((spell = SPELLS.get(player)) != null) {
            ServerNetworkHandler.castSpell(player, spell, null);
        }
    }

    private static void castSpell(class_3222 player, Spell spell, @Nullable ElementSymbol elementSymbol) {
        player.method_51469().method_43129(null, (class_1297)player, class_3417.field_14908, class_3419.field_15248, 0.5f, 1.0f);
        if (spell.objectType() == Spell.ObjectType.INVALID) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new CastEndPacketPayload(CastEndPacketPayload.Reason.NO_SPELL));
            ServerNetworkHandler.invalidSpell(player);
            SPELLS.put((class_1657)player, null);
            return;
        }
        int mutations = spell.mutations();
        if (mutations > 20 || mutations > 3 && (double)(player.method_51469().field_9229.method_43057() * 100.0f) < Math.pow(mutations, 1.353984985057691)) {
            ServerNetworkHandler.consume(player);
            SPELLS.put((class_1657)player, null);
            return;
        }
        TICKABLES.add(new SpellCooldownAwaiter(spell, elementSymbol, player));
        SPELLS.put((class_1657)player, null);
    }

    private static void consume(class_3222 player) {
        player.method_6092(new class_1293(class_1294.field_38092, -1, 255, false, false, false));
        player.method_6092(new class_1293(class_1294.field_5919, -1, 255, false, false, false));
        player.method_5996(class_5134.field_23719).method_6192(-1.0);
        player.method_5996(class_5134.field_23723).method_6192(0.0);
        player.method_5996(class_5134.field_23728).method_6192(0.0);
        player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"gsscs.message.void.loud")));
        TICKABLES.add(new VoidConsumeAwaiter(player));
    }

    private static void invalidSpell(class_3222 player) {
        player.method_51469().method_43129(null, (class_1297)player, class_3417.field_15203, class_3419.field_15248, 0.5f, 1.0f);
        player.method_51469().method_65096((class_2394)class_2398.field_11215, player.method_23317(), player.method_23320(), player.method_23321(), 50, 1.0, 2.0, 1.0, 2.0);
        player.method_51469().method_65096((class_2394)new class_5743(10116294, 0xFFFFFF, 1.0f), player.method_23317(), player.method_23320(), player.method_23321(), 50, 1.0, 2.0, 1.0, -2.0);
    }

    static {
        TickEvent.PLAYER_POST.register(ServerNetworkHandler::tick);
    }

    private static interface Tickable {
        public void tick(class_1657 var1);

        default public void remove() {
            TO_REMOVE_TICKABLES.add(this);
        }
    }

    private static class SpellCooldownAwaiter
    implements Tickable {
        private final Spell spell;
        private final ElementSymbol elementSymbol;
        private final class_3222 player;
        private int tick = 0;

        public SpellCooldownAwaiter(Spell spell, ElementSymbol elementSymbol, class_3222 player) {
            this.spell = spell;
            this.elementSymbol = elementSymbol;
            this.player = player;
        }

        @Override
        public void tick(class_1657 p) {
            class_3222 player;
            if (!(p instanceof class_3222) || !(player = (class_3222)p).equals((Object)this.player)) {
                return;
            }
            if (this.tick == 20) {
                p.method_73183().method_43129(null, (class_1297)p, class_3417.field_14908, class_3419.field_15248, 0.5f, 1.0f);
                this.spell.cast(this.elementSymbol == null ? ElementSymbol.NONE : this.elementSymbol);
                player.field_6007 = true;
                this.remove();
                return;
            }
            ++this.tick;
        }
    }

    private static class VoidConsumeAwaiter
    implements Tickable {
        private int tick = 0;
        private final class_3222 player;

        public VoidConsumeAwaiter(class_3222 player) {
            this.player = player;
        }

        @Override
        public void tick(class_1657 p) {
            class_3222 player;
            if (!(p instanceof class_3222) || !(player = (class_3222)p).equals((Object)this.player)) {
                return;
            }
            if (this.tick == 30) {
                player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"gsscs.message.void.silence")));
                player.method_51469().method_43129(null, (class_1297)player, class_3417.field_38075, class_3419.field_15250, 0.1f, 0.1f);
                player.method_5859(player.method_23317(), -32768.0, player.method_23321());
                player.method_5996(class_5134.field_23719).method_6192(0.1);
                player.method_5996(class_5134.field_23723).method_6192(((class_1320)class_5134.field_23723.comp_349()).method_6169());
                player.method_5996(class_5134.field_23728).method_6192(((class_1320)class_5134.field_23728.comp_349()).method_6169());
                this.remove();
                return;
            }
            ++this.tick;
        }
    }
}

