/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.spells.symbols;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import ma.shaur.gsscs.spells.symbols.AbstractSymbol;
import ma.shaur.gsscs.spells.symbols.FormSymbol;
import ma.shaur.gsscs.spells.symbols.Recognizer;
import ma.shaur.gsscs.spells.symbols.SymbolStorage;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_7654;
import org.slf4j.Logger;

public class Identifier
extends class_4309<SymbolStorage> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_7654 ASSET_LISTER = class_7654.method_45114((String)"spells");
    public static final Codec<Recognizer.Gesture> GESTURE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.listOf().fieldOf("points").forGetter(gesture -> {
        ArrayList<Float> list = new ArrayList<Float>();
        for (Recognizer.Point point : gesture.getPoints()) {
            list.add(Float.valueOf(point.getX()));
            list.add(Float.valueOf(point.getY()));
        }
        return list;
    })).apply((Applicative)instance, floats -> {
        Recognizer.Point[] points = new Recognizer.Point[floats.size() / 2];
        if (points.length < 2) {
            LOGGER.error("Gesture float array [" + floats.stream().map(Object::toString).collect(Collectors.joining(",")) + "] is too short!");
            return null;
        }
        for (int i = 0; i < floats.size(); i += 2) {
            points[i / 2] = new Recognizer.Point(((Float)floats.get(i)).floatValue(), ((Float)floats.get(i + 1)).floatValue(), i / 4);
        }
        return new Recognizer.Gesture(points);
    }));
    public static final Codec<SymbolStorage> SYMBOL_STORAGE = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_63572((Codec)Codec.unboundedMap((Codec)Codec.STRING, GESTURE_CODEC)).fieldOf("byName").forGetter(SymbolStorage::gestures)).apply((Applicative)instance, SymbolStorage::new));
    private SymbolStorage storage = null;

    public Identifier() {
        super(SYMBOL_STORAGE, ASSET_LISTER);
    }

    public void setStorage(SymbolStorage storage) {
        this.storage = storage;
    }

    public SymbolStorage getStorage() {
        return this.storage;
    }

    protected void apply(Map<class_2960, SymbolStorage> object, class_3300 resourceManager, class_3695 profiler) {
        this.storage = null;
        for (SymbolStorage store : object.values()) {
            if (this.storage == null) {
                this.storage = store;
                continue;
            }
            this.storage.gestures(store.gestures());
        }
    }

    public Map<String, AbstractSymbol> symbols() {
        return this.storage.symbols();
    }

    public FormSymbol identifyForm(Recognizer.Point[] points) {
        TreeMap<String, Float> symbols = Recognizer.QPointCloudRecognizer.classify(new Recognizer.Gesture(points), this.storage.formSymbols());
        System.out.println(symbols);
        String key = symbols.entrySet().iterator().next().getKey();
        return (FormSymbol)(symbols.get(key).floatValue() > 8.0f ? null : this.storage.symbol(key));
    }

    public AbstractSymbol identifyAffectOrElement(Recognizer.Point[] points) {
        TreeMap<String, Float> symbols = Recognizer.QPointCloudRecognizer.classify(new Recognizer.Gesture(points), this.storage.affectAndElementSymbols());
        System.out.println(symbols);
        String key = symbols.entrySet().iterator().next().getKey();
        return symbols.get(key).floatValue() > 16.0f ? null : this.storage.symbol(key);
    }

    public float distance(Recognizer.Gesture gesture, Recognizer.Gesture symbol) {
        return Recognizer.QPointCloudRecognizer.greedyCloudMatch(gesture, symbol, Float.MAX_VALUE);
    }
}

