/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.spells.symbols;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ma.shaur.gsscs.spells.symbols.AbstractSymbol;

public class Recognizer {

    public class QPointCloudRecognizer {
        public static boolean UseEarlyAbandoning = true;
        public static boolean UseLowerBounding = true;

        public QPointCloudRecognizer(Recognizer this$0) {
        }

        public static TreeMap<String, Float> classify(Gesture candidate, List<Map.Entry<String, AbstractSymbol>> symbols) {
            TreeMap<String, Float> result = new TreeMap<String, Float>();
            for (Map.Entry<String, AbstractSymbol> symbol : symbols) {
                float dist = QPointCloudRecognizer.greedyCloudMatch(candidate, symbol.getValue().getGesture(), Float.MAX_VALUE);
                result.put(symbol.getKey(), Float.valueOf(dist));
            }
            TreeMap<String, Float> resultSorted = new TreeMap<String, Float>((a, b) -> (int)Math.signum(((Float)result.get(a)).floatValue() - ((Float)result.get(b)).floatValue()));
            resultSorted.putAll(result);
            return resultSorted;
        }

        public static float greedyCloudMatch(Gesture gesture1, Gesture gesture2, float minSoFar) {
            int n = gesture1.points.length;
            float eps = 0.5f;
            int step = (int)Math.floor(Math.pow(n, 1.0f - eps));
            if (UseLowerBounding) {
                float[] LB1 = QPointCloudRecognizer.computeLowerBound(gesture1.points, gesture2.points, gesture2.LUT, step);
                float[] LB2 = QPointCloudRecognizer.computeLowerBound(gesture2.points, gesture1.points, gesture1.LUT, step);
                int i = 0;
                int indexLB = 0;
                while (i < n) {
                    if (LB1[indexLB] < minSoFar) {
                        minSoFar = Math.min(minSoFar, QPointCloudRecognizer.cloudDistance(gesture1.points, gesture2.points, i, minSoFar));
                    }
                    if (LB2[indexLB] < minSoFar) {
                        minSoFar = Math.min(minSoFar, QPointCloudRecognizer.cloudDistance(gesture2.points, gesture1.points, i, minSoFar));
                    }
                    i += step;
                    ++indexLB;
                }
            } else {
                for (int i = 0; i < n; i += step) {
                    minSoFar = Math.min(minSoFar, QPointCloudRecognizer.cloudDistance(gesture1.points, gesture2.points, i, minSoFar));
                    minSoFar = Math.min(minSoFar, QPointCloudRecognizer.cloudDistance(gesture2.points, gesture1.points, i, minSoFar));
                }
            }
            return minSoFar;
        }

        private static float[] computeLowerBound(Point[] points1, Point[] points2, int[][] LUT, int step) {
            int i;
            int n = points1.length;
            float[] LB = new float[n / step + 1];
            float[] SAT = new float[n];
            LB[0] = 0.0f;
            for (i = 0; i < n; ++i) {
                int index = LUT[points1[i].intY / Gesture.LUT_SCALE_FACTOR][points1[i].intX / Gesture.LUT_SCALE_FACTOR];
                float dist = Geometry.SqrEuclideanDistance(points1[i], points2[index]);
                SAT[i] = i == 0 ? dist : SAT[i - 1] + dist;
                LB[0] = LB[0] + (float)(n - i) * dist;
            }
            i = step;
            int indexLB = 1;
            while (i < n) {
                LB[indexLB] = LB[0] + (float)i * SAT[n - 1] - (float)n * SAT[i - 1];
                i += step;
                ++indexLB;
            }
            return LB;
        }

        private static float cloudDistance(Point[] points1, Point[] points2, int startIndex, float minSoFar) {
            int n = points1.length;
            int[] indexesNotMatched = new int[n];
            for (int j = 0; j < n; ++j) {
                indexesNotMatched[j] = j;
            }
            float sum = 0.0f;
            int i = startIndex;
            int weight = n;
            int indexNotMatched = 0;
            do {
                int index = -1;
                float minDistance = Float.MAX_VALUE;
                for (int j = indexNotMatched; j < n; ++j) {
                    float dist = Geometry.SqrEuclideanDistance(points1[i], points2[indexesNotMatched[j]]);
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    index = j;
                }
                indexesNotMatched[index] = indexesNotMatched[indexNotMatched];
                sum += (float)weight-- * minDistance;
                if (UseEarlyAbandoning && sum >= minSoFar) {
                    return sum;
                }
                i = (i + 1) % n;
                ++indexNotMatched;
            } while (i != startIndex);
            return sum;
        }
    }

    public static class Gesture {
        private Point[] points = null;
        private Point[] pointsRaw = null;
        private static final int SAMPLING_RESOLUTION = 64;
        private static final int MAX_INT_COORDINATES = 1024;
        private static int LUT_SIZE = 64;
        private static int LUT_SCALE_FACTOR = 1024 / LUT_SIZE;
        private int[][] LUT = null;

        public static void setLutSize(int lut) {
            LUT_SIZE = lut;
            LUT_SCALE_FACTOR = 1024 / LUT_SIZE;
        }

        public Gesture(Point[] points) {
            this(points, true);
        }

        public Gesture(Point[] points, boolean computeLUT) {
            this.pointsRaw = points;
            this.normalize(computeLUT);
        }

        public Point[] getPoints() {
            return this.points;
        }

        public void normalize(boolean computeLUT) {
            this.points = this.resample(this.pointsRaw, 64);
            this.points = this.scale(this.points);
            this.points = this.translateTo(this.points, this.centroid(this.points));
            if (computeLUT) {
                this.transformCoordinatesToIntegers();
                this.constructLUT();
            }
        }

        private Point[] scale(Point[] points) {
            float minx = Float.MAX_VALUE;
            float miny = Float.MAX_VALUE;
            float maxx = Float.MIN_VALUE;
            float maxy = Float.MIN_VALUE;
            for (int i = 0; i < points.length; ++i) {
                if (minx > points[i].X) {
                    minx = points[i].X;
                }
                if (miny > points[i].Y) {
                    miny = points[i].Y;
                }
                if (maxx < points[i].X) {
                    maxx = points[i].X;
                }
                if (!(maxy < points[i].Y)) continue;
                maxy = points[i].Y;
            }
            Point[] newPoints = new Point[points.length];
            float scale = Math.max(maxx - minx, maxy - miny);
            for (int i = 0; i < points.length; ++i) {
                newPoints[i] = new Point((points[i].X - minx) / scale, (points[i].Y - miny) / scale, points[i].StrokeID);
            }
            return newPoints;
        }

        private Point[] translateTo(Point[] points, Point p) {
            Point[] newPoints = new Point[points.length];
            for (int i = 0; i < points.length; ++i) {
                newPoints[i] = new Point(points[i].X - p.X, points[i].Y - p.Y, points[i].StrokeID);
            }
            return newPoints;
        }

        private Point centroid(Point[] points) {
            float cx = 0.0f;
            float cy = 0.0f;
            for (int i = 0; i < points.length; ++i) {
                cx += points[i].X;
                cy += points[i].Y;
            }
            return new Point(cx / (float)points.length, cy / (float)points.length, 0);
        }

        public Point[] resample(Point[] points, int n) {
            Point[] newPoints = new Point[n];
            newPoints[0] = new Point(points[0].X, points[0].Y, points[0].StrokeID);
            int numPoints = 1;
            float I = this.pathLength(points) / (float)(n - 1);
            float D = 0.0f;
            for (int i = 1; i < points.length; ++i) {
                if (points[i].StrokeID != points[i - 1].StrokeID) continue;
                float d = Geometry.EuclideanDistance(points[i - 1], points[i]);
                if (D + d >= I) {
                    Point firstPoint = points[i - 1];
                    while (D + d >= I) {
                        float t = Math.min(Math.max((I - D) / d, 0.0f), 1.0f);
                        if (Float.isNaN(t)) {
                            t = 0.5f;
                        }
                        newPoints[numPoints++] = new Point((1.0f - t) * firstPoint.X + t * points[i].X, (1.0f - t) * firstPoint.Y + t * points[i].Y, points[i].StrokeID);
                        d = D + d - I;
                        D = 0.0f;
                        firstPoint = newPoints[numPoints - 1];
                    }
                    D = d;
                    continue;
                }
                D += d;
            }
            if (numPoints == n - 1) {
                newPoints[numPoints++] = new Point(points[points.length - 1].X, points[points.length - 1].Y, points[points.length - 1].StrokeID);
            }
            return newPoints;
        }

        private float pathLength(Point[] points) {
            float length = 0.0f;
            for (int i = 1; i < points.length; ++i) {
                if (points[i].StrokeID != points[i - 1].StrokeID) continue;
                length += Geometry.EuclideanDistance(points[i - 1], points[i]);
            }
            return length;
        }

        private void transformCoordinatesToIntegers() {
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i].intX = (int)((this.points[i].X + 1.0f) / 2.0f * 1023.0f);
                this.points[i].intY = (int)((this.points[i].Y + 1.0f) / 2.0f * 1023.0f);
            }
        }

        private void constructLUT() {
            int i;
            this.LUT = new int[LUT_SIZE][];
            for (i = 0; i < LUT_SIZE; ++i) {
                this.LUT[i] = new int[LUT_SIZE];
            }
            for (i = 0; i < LUT_SIZE; ++i) {
                for (int j = 0; j < LUT_SIZE; ++j) {
                    int minDistance = Integer.MAX_VALUE;
                    int indexMin = -1;
                    for (int t = 0; t < this.points.length; ++t) {
                        int row = this.points[t].intY / LUT_SCALE_FACTOR;
                        int col = this.points[t].intX / LUT_SCALE_FACTOR;
                        int dist = (row - i) * (row - i) + (col - j) * (col - j);
                        if (dist >= minDistance) continue;
                        minDistance = dist;
                        indexMin = t;
                    }
                    this.LUT[i][j] = indexMin;
                }
            }
        }
    }

    public static class Geometry {
        public static float SqrEuclideanDistance(Point a, Point b) {
            return (a.X - b.X) * (a.X - b.X) + (a.Y - b.Y) * (a.Y - b.Y);
        }

        public static float EuclideanDistance(Point a, Point b) {
            return (float)Math.sqrt(Geometry.SqrEuclideanDistance(a, b));
        }
    }

    public static class Point {
        private float X;
        private float Y;
        private int StrokeID;
        private int intX;
        private int intY;

        public Point(float x, float y, int strokeId) {
            this.X = x;
            this.Y = y;
            this.StrokeID = strokeId;
            this.intX = 0;
            this.intY = 0;
        }

        public float getX() {
            return this.X;
        }

        public float getY() {
            return this.Y;
        }

        public int getStrokeID() {
            return this.StrokeID;
        }
    }
}

