/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.gsscs.spells.symbols;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ma.shaur.gsscs.mixin.LargeFireballAccessor;
import ma.shaur.gsscs.spells.Spell;
import ma.shaur.gsscs.spells.symbols.AbstractSymbol;
import ma.shaur.gsscs.spells.symbols.AffectSymbol;
import ma.shaur.gsscs.spells.symbols.ElementSymbol;
import ma.shaur.gsscs.spells.symbols.FormSymbol;
import ma.shaur.gsscs.spells.symbols.Recognizer;
import net.minecraft.class_10691;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1670;
import net.minecraft.class_1673;
import net.minecraft.class_1674;
import net.minecraft.class_1676;
import net.minecraft.class_1677;
import net.minecraft.class_1678;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4019;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_8956;
import net.minecraft.class_9238;
import net.minecraft.class_9334;

public class SymbolStorage {
    private static Predicate<AbstractSymbol> FORM_SYMBOLS = symbol -> symbol instanceof FormSymbol;
    private static Predicate<AbstractSymbol> AFFECT_SYMBOLS = symbol -> symbol instanceof AffectSymbol;
    private static Predicate<AbstractSymbol> ELEMENT_SYMBOLS = symbol -> symbol instanceof ElementSymbol;
    private Map<String, AbstractSymbol> symbols = new LinkedHashMap<String, AbstractSymbol>();

    public SymbolStorage(Map<String, Recognizer.Gesture> gestures) {
        this.symbols.put("self", new FormSymbol(null, Spell.ObjectType.CASTER));
        this.symbols.put("smallProj", new FormSymbol(null, Spell.ObjectType.SMALL_PROJ));
        this.symbols.put("largeProj", new FormSymbol(null, Spell.ObjectType.LARGE_PROJ));
        this.symbols.put("fast", new AffectSymbol(null, spell -> {
            class_1309 caster = spell.caster();
            caster.method_6026().forEach(effect -> effect.method_5590(effect.method_66227(0.75f)));
            if (caster.method_5809()) {
                caster.method_20803((int)((float)caster.method_20802() * 0.75f));
            }
            return spell;
        }, spell -> {
            for (class_1297 entity : spell.spell()) {
                entity.method_18799(entity.method_18798().method_18805(2.0, 2.0, 2.0));
            }
            return spell;
        }, spell -> {
            int length = spell.spell().length;
            if (spell.caster().method_6123()) {
                spell.caster().method_45319(class_243.method_1034((class_241)spell.caster().method_5802()));
            }
            System.out.println(spell.caster().method_6123());
            System.out.println(spell.caster().method_18798());
            if (length == 0) {
                return spell;
            }
            class_1297 center = spell.spell()[length / 2];
            if (center instanceof class_10691) {
                class_10691 centerPotion = (class_10691)center;
                ArrayList amplified = new ArrayList();
                ((class_1844)centerPotion.method_7495().method_58694(class_9334.field_49651)).method_57402(effect -> amplified.add(effect), 0.75f);
                for (class_1297 e : spell.spell()) {
                    if (!(e instanceof class_10691)) continue;
                    class_10691 potion = (class_10691)e;
                    potion.method_7495().method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), amplified, Optional.empty()));
                }
                return spell;
            }
            for (class_1297 entity : spell.spell()) {
                entity.method_18799(entity.method_18798().method_18805(2.0, 2.0, 2.0));
            }
            return spell;
        }));
        this.symbols.put("slow", new AffectSymbol(null, spell -> {
            class_1309 caster = spell.caster();
            caster.method_6026().forEach(effect -> caster.method_6092(effect.method_66227(1.5f)));
            if (caster.method_5809()) {
                caster.method_20803((int)((float)caster.method_20802() * 1.5f));
            }
            if (caster.method_6123()) {
                caster.method_18799(caster.method_18798().method_18805(0.75, 0.75, 0.75));
            }
            return spell;
        }, spell -> {
            for (class_1297 entity : spell.spell()) {
                entity.method_18799(entity.method_18798().method_18805(0.5, 0.5, 0.5));
            }
            return spell;
        }, spell -> {
            int length = spell.spell().length;
            if (spell.caster().method_6123()) {
                spell.caster().method_45319(class_243.method_1034((class_241)spell.caster().method_5802()));
            }
            System.out.println(spell.caster().method_6123());
            System.out.println(spell.caster().method_18798());
            if (length == 0) {
                return spell;
            }
            class_1297 center = spell.spell()[length / 2];
            if (center instanceof class_10691) {
                class_10691 centerPotion = (class_10691)center;
                ArrayList amplified = new ArrayList();
                ((class_1844)centerPotion.method_7495().method_58694(class_9334.field_49651)).method_57402(effect -> amplified.add(effect), 1.5f);
                for (class_1297 e : spell.spell()) {
                    if (!(e instanceof class_10691)) continue;
                    class_10691 potion = (class_10691)e;
                    potion.method_7495().method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), amplified, Optional.empty()));
                }
                return spell;
            }
            for (class_1297 entity : spell.spell()) {
                entity.method_18799(entity.method_18798().method_18805(0.5, 0.5, 0.5));
            }
            return spell;
        }));
        this.symbols.put("multiply", new AffectSymbol(null, spell -> {
            for (class_1293 effect : spell.caster().method_6026()) {
                effect.method_5590(new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578() + 1, effect.method_5591(), effect.method_5581(), effect.method_5592()));
            }
            return spell;
        }, spell -> SymbolStorage.multiplyGeneric(spell), spell -> {
            int length = spell.spell().length;
            class_1297 entity = spell.spell()[length / 2];
            if (entity instanceof class_10691) {
                class_10691 centerPotion = (class_10691)entity;
                ArrayList amplified = new ArrayList();
                ((class_1844)centerPotion.method_7495().method_58694(class_9334.field_49651)).method_57402(effect -> amplified.add(new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578() + 1, effect.method_5591(), effect.method_5581(), effect.method_5592())), 1.0f);
                for (class_1297 e : spell.spell()) {
                    if (!(e instanceof class_10691)) continue;
                    class_10691 potion = (class_10691)e;
                    potion.method_7495().method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), amplified, Optional.empty()));
                }
                return spell;
            }
            if (entity instanceof class_1674) {
                for (class_1297 e : spell.spell()) {
                    if (!(e instanceof LargeFireballAccessor)) continue;
                    LargeFireballAccessor fireball = (LargeFireballAccessor)e;
                    fireball.explosionPower(fireball.explosionPower() + 1);
                }
                return spell;
            }
            if (entity instanceof class_9238) {
                class_1297[] entities = spell.spell();
                class_1297[] newEntities = new class_1297[(int)Math.ceil((double)entities.length * 1.5)];
                System.arraycopy(entities, 0, newEntities, 0, entities.length);
                for (int i = entities.length; i < newEntities.length; ++i) {
                    newEntities[i] = new class_9238(class_1299.field_49075, spell.caster().method_73183());
                    ((class_1676)newEntities[i]).method_7432((class_1297)spell.caster());
                    newEntities[i].method_5859(entity.method_23317(), entity.method_23318(), entity.method_23321());
                    newEntities[i].method_18799(entity.method_18798());
                }
                return spell.withSpell(newEntities);
            }
            return SymbolStorage.multiplyGeneric(spell);
        }));
        this.symbols.put("fire", new ElementSymbol(null, spell -> {
            switch (spell.objectType()) {
                case CASTER: {
                    spell.caster().method_56073(200);
                    break;
                }
                case SMALL_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new class_1677(spell.spell()[i].method_73183(), spell.caster(), class_243.method_1034((class_241)spell.caster().method_5802()));
                        spell.spell()[i].method_45166(0.0, (double)spell.caster().method_5751(), 0.0);
                    }
                    break;
                }
                case LARGE_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new class_1674(spell.spell()[i].method_73183(), spell.caster(), class_243.method_1034((class_241)spell.caster().method_5802()), 3);
                        spell.spell()[i].method_45166(0.0, (double)spell.caster().method_5751(), 0.0);
                    }
                    break;
                }
            }
            return spell;
        }));
        this.symbols.put("water", new ElementSymbol(null, spell -> {
            switch (spell.objectType()) {
                case CASTER: {
                    class_243 vec = spell.caster().method_33571();
                    spell.caster().method_73183().method_8501(new class_2338((int)vec.field_1352, (int)vec.field_1351, (int)vec.field_1350), class_2246.field_10382.method_9564());
                    break;
                }
                case SMALL_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        class_243 momentum = spell.spell()[i].method_18798();
                        class_243 vec3 = spell.spell()[i].method_73189();
                        spell.spell()[i] = new class_1673(class_1299.field_6124, spell.caster().method_73183());
                        ((class_1676)spell.spell()[i]).method_7432((class_1297)spell.caster());
                        spell.spell()[i].method_5859(vec3.field_1352, vec3.field_1351, vec3.field_1350);
                        spell.spell()[i].method_18799(momentum);
                    }
                    break;
                }
                case LARGE_PROJ: {
                    class_1309 patt0$temp;
                    if (spell.caster().method_5721() && (patt0$temp = spell.caster()) instanceof class_1657) {
                        class_1657 player = (class_1657)patt0$temp;
                        player.method_60491(class_243.method_1034((class_241)player.method_5802()).method_18805(10.0, 10.0, 10.0));
                        player.method_40126(20, 8.0f, player.method_6047());
                        if (player.method_24828()) {
                            player.method_5784(class_1313.field_6308, new class_243(0.0, 1.1999999284744263, 0.0));
                        }
                        player.method_73183().method_43129(null, (class_1297)player, (class_3414)class_3417.field_14606.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                        System.out.println(spell.caster().method_6123());
                        System.out.println(spell.caster().method_18798());
                        System.out.println(spell.caster().field_6007);
                        return spell.withSpell(new class_1297[0]);
                    }
                    class_1799 itemStack = new class_1799((class_1935)class_1802.field_8436);
                    itemStack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), new ArrayList(spell.caster().method_6026()), Optional.empty()));
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new class_10691(spell.spell()[i].method_73183(), spell.caster(), itemStack);
                        spell.spell()[i].method_18799(class_243.method_1034((class_241)spell.caster().method_5802()));
                    }
                    break;
                }
            }
            return spell;
        }));
        this.symbols.put("wind", new ElementSymbol(null, spell -> {
            switch (spell.objectType()) {
                case CASTER: {
                    spell.caster().method_6092(new class_1293(class_1294.field_5906, 600, 0));
                    spell.caster().method_6092(new class_1293(class_1294.field_5904, 600, 0));
                    spell.caster().method_6092(new class_1293(class_1294.field_5913, 600, 0));
                    break;
                }
                case SMALL_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        class_243 momentum = spell.spell()[i].method_18798();
                        class_243 vec3 = spell.spell()[i].method_73189();
                        spell.spell()[i] = new class_8956(spell.spell()[i].method_73183(), vec3.field_1352, vec3.field_1351, vec3.field_1350, class_243.method_1034((class_241)spell.caster().method_5802()));
                        ((class_1676)spell.spell()[i]).method_7432((class_1297)spell.caster());
                        spell.spell()[i].method_18799(momentum);
                    }
                    break;
                }
                case LARGE_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        class_243 vec3 = spell.spell()[i].method_73189();
                        class_243 momentum = spell.spell()[i].method_18798();
                        spell.spell()[i] = new class_9238(class_1299.field_49075, spell.caster().method_73183());
                        ((class_1676)spell.spell()[i]).method_7432((class_1297)spell.caster());
                        spell.spell()[i].method_5859(vec3.field_1352, vec3.field_1351, vec3.field_1350);
                        spell.spell()[i].method_18799(momentum);
                    }
                    break;
                }
            }
            return spell;
        }));
        this.symbols.put("end", new ElementSymbol(null, spell -> {
            block0 : switch (spell.objectType()) {
                case CASTER: {
                    class_1309 caster = spell.caster();
                    for (int i = 0; i < 16; ++i) {
                        class_3419 soundSource;
                        class_3414 soundEvent;
                        double x = caster.method_23317() + (caster.method_59922().method_43058() - 0.5) * 16.0;
                        double y = class_3532.method_15350((double)(caster.method_23318() + (caster.method_59922().method_43058() - 0.5) * 16.0), (double)caster.method_73183().method_31607(), (double)(caster.method_73183().method_31607() + ((class_3218)caster.method_73183()).method_32819() - 1));
                        double z = caster.method_23321() + (caster.method_59922().method_43058() - 0.5) * 16.0;
                        if (caster.method_5765()) {
                            caster.method_5848();
                        }
                        class_243 vec3 = caster.method_73189();
                        if (!caster.method_6082(x, y, z, true)) continue;
                        caster.method_73183().method_32888((class_6880)class_5712.field_39446, vec3, class_5712.class_7397.method_43285((class_1297)caster));
                        if (caster instanceof class_4019) {
                            soundEvent = class_3417.field_24630;
                            soundSource = class_3419.field_15254;
                        } else {
                            soundEvent = class_3417.field_14890;
                            soundSource = class_3419.field_15248;
                        }
                        caster.method_73183().method_54762(null, caster.method_23317(), caster.method_23318(), caster.method_23321(), soundEvent, soundSource);
                        caster.method_38785();
                        break block0;
                    }
                    break;
                }
                case SMALL_PROJ: {
                    class_1297 target = null;
                    double minDist = Double.MAX_VALUE;
                    for (class_1297 entity : spell.caster().method_73183().method_18467(class_1309.class, spell.caster().method_5829().method_18804(class_243.method_1034((class_241)spell.caster().method_5802()).method_18805(64.0, 64.0, 64.0)))) {
                        double dist;
                        if (spell.caster() == entity || !spell.caster().method_6057(entity) || !((dist = spell.caster().method_73189().method_1025(entity.method_73189())) < minDist)) continue;
                        target = entity;
                        minDist = dist;
                    }
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new class_1678(spell.spell()[i].method_73183(), spell.caster(), target, spell.caster().method_5735().method_10166());
                    }
                    break;
                }
                case LARGE_PROJ: {
                    for (int i = 0; i < spell.spell().length; ++i) {
                        spell.spell()[i] = new class_1670(spell.spell()[i].method_73183(), spell.caster(), class_243.method_1034((class_241)spell.caster().method_5802()));
                    }
                    break;
                }
            }
            return spell;
        }));
        if (gestures != null) {
            this.gestures(gestures);
        }
    }

    private static Spell multiplyGeneric(Spell spell) {
        int i;
        int length = spell.spell().length;
        class_1297 entity = spell.spell()[length / 2];
        class_8942.class_8943 collector = new class_8942.class_8943();
        class_11362 output = class_11362.method_71458((class_8942)collector);
        entity.method_5662((class_11372)output);
        output.method_71468("pickup", class_1665.class_1666.field_56665, (Object)class_1665.class_1666.field_7592);
        class_11368 input = class_11352.method_71417((class_8942)collector, (class_7225.class_7874)entity.method_73183().method_30349(), (class_2487)output.method_71475());
        if (length == 1) {
            class_1297 copy1 = (class_1297)class_1299.method_5892((class_11368)input, (class_1937)entity.method_73183(), (class_3730)class_3730.field_16467).get();
            class_1297 copy2 = (class_1297)class_1299.method_5892((class_11368)input, (class_1937)entity.method_73183(), (class_3730)class_3730.field_16467).get();
            copy1.method_18799(entity.method_18798());
            copy2.method_18799(entity.method_18798());
            copy1.method_5826(class_3532.method_15378((class_5819)copy1.method_59922()));
            copy2.method_5826(class_3532.method_15378((class_5819)copy2.method_59922()));
            class_243 horizontal = class_243.method_1030((float)0.0f, (float)(entity.method_36454() + 90.0f));
            copy1.method_45166(horizontal.field_1352, horizontal.field_1351, horizontal.field_1350);
            copy2.method_45166(-horizontal.field_1352, -horizontal.field_1351, -horizontal.field_1350);
            return spell.withSpell(copy1, entity, copy2);
        }
        if (length == 3) {
            class_1297[] entities = new class_1297[9];
            for (int i2 = 0; i2 < 3; ++i2) {
                entities[i2] = (class_1297)class_1299.method_5892((class_11368)input, (class_1937)entity.method_73183(), (class_3730)class_3730.field_16467).get();
                entities[i2 + 3] = spell.spell()[i2];
                entities[i2 + 6] = (class_1297)class_1299.method_5892((class_11368)input, (class_1937)entity.method_73183(), (class_3730)class_3730.field_16467).get();
                entities[i2].method_18799(entity.method_18798());
                entities[i2 + 6].method_18799(entity.method_18798());
                entities[i2].method_5826(class_3532.method_15378((class_5819)entities[i2].method_59922()));
                entities[i2 + 6].method_5826(class_3532.method_15378((class_5819)entities[i2 + 6].method_59922()));
                class_243 horizontal = class_243.method_1030((float)0.0f, (float)(entity.method_36454() + 90.0f));
                horizontal = horizontal.method_18805((double)(i2 - 1), (double)(i2 - 1), (double)(i2 - 1));
                class_243 vertical = class_243.method_1030((float)(entity.method_36455() + 90.0f), (float)entity.method_36454());
                entities[i2].method_45166(vertical.field_1352 + horizontal.field_1352, vertical.field_1351 + horizontal.field_1351, vertical.field_1350 + horizontal.field_1350);
                entities[i2 + 6].method_45166(-vertical.field_1352 + horizontal.field_1352, -vertical.field_1351 + horizontal.field_1351, -vertical.field_1350 + horizontal.field_1350);
            }
            return spell.withSpell(entities);
        }
        int sqrt = (int)Math.sqrt(length);
        int newSide = sqrt + 2;
        int halfSide = newSide / 2;
        class_1297[] entities = new class_1297[newSide * newSide];
        int padding = (entities.length - length) / 2;
        int halfPadding = padding / 2;
        System.arraycopy(spell.spell(), 0, entities, padding, length);
        class_243 horizontal = class_243.method_1030((float)0.0f, (float)(entity.method_36454() + 90.0f));
        class_243 vertical = class_243.method_1030((float)(entity.method_36455() + 90.0f), (float)entity.method_36454());
        class_243 shift = class_243.field_1353.method_1019(horizontal.method_18805((double)halfSide, (double)halfSide, (double)halfSide)).method_1019(vertical.method_18805((double)halfSide, (double)halfSide, (double)halfSide));
        horizontal = horizontal.method_18805(-1.0, -1.0, -1.0);
        vertical = vertical.method_18805(-1.0, -1.0, -1.0);
        for (i = 0; i < halfPadding; ++i) {
            entities[i] = (class_1297)class_1299.method_5892((class_11368)input, (class_1937)entity.method_73183(), (class_3730)class_3730.field_16467).get();
            entities[i].method_18799(entity.method_18798());
            entities[i].method_5826(class_3532.method_15378((class_5819)entities[0].method_59922()));
            entities[i].method_45166(shift.field_1352, shift.field_1351, shift.field_1350);
            shift = shift.method_1019(horizontal);
        }
        for (i = halfPadding; i < padding; ++i) {
            entities[i] = (class_1297)class_1299.method_5892((class_11368)input, (class_1937)entity.method_73183(), (class_3730)class_3730.field_16467).get();
            entities[i].method_18799(entity.method_18798());
            entities[i].method_5826(class_3532.method_15378((class_5819)entities[0].method_59922()));
            entities[i].method_45166(shift.field_1352, shift.field_1351, shift.field_1350);
            shift = shift.method_1019(vertical);
        }
        horizontal = horizontal.method_18805(-1.0, -1.0, -1.0);
        vertical = vertical.method_18805(-1.0, -1.0, -1.0);
        for (i = length + padding; i < entities.length - halfPadding; ++i) {
            entities[i] = (class_1297)class_1299.method_5892((class_11368)input, (class_1937)entity.method_73183(), (class_3730)class_3730.field_16467).get();
            entities[i].method_18799(entity.method_18798());
            entities[i].method_5826(class_3532.method_15378((class_5819)entities[0].method_59922()));
            entities[i].method_45166(shift.field_1352, shift.field_1351, shift.field_1350);
            shift = shift.method_1019(horizontal);
        }
        for (i = entities.length - halfPadding; i < entities.length; ++i) {
            entities[i] = (class_1297)class_1299.method_5892((class_11368)input, (class_1937)entity.method_73183(), (class_3730)class_3730.field_16467).get();
            entities[i].method_18799(entity.method_18798());
            entities[i].method_5826(class_3532.method_15378((class_5819)entities[0].method_59922()));
            entities[i].method_45166(shift.field_1352, shift.field_1351, shift.field_1350);
            shift = shift.method_1019(vertical);
        }
        return spell.withSpell(entities);
    }

    public void gestures(Map<String, Recognizer.Gesture> gestures) {
        for (String name : gestures.keySet()) {
            if (!this.symbols.containsKey(name)) continue;
            this.symbols.get(name).setGesture(gestures.get(name));
        }
    }

    public Map<String, Recognizer.Gesture> gestures() {
        return this.symbols.keySet().stream().collect(Collectors.toMap(name -> name, name -> this.symbols.get(name).getGesture()));
    }

    public AbstractSymbol symbol(String name) {
        return this.symbols.get(name);
    }

    public Map<String, AbstractSymbol> symbols() {
        return new LinkedHashMap<String, AbstractSymbol>(this.symbols);
    }

    public List<Map.Entry<String, AbstractSymbol>> formSymbols() {
        return this.symbols.entrySet().stream().filter(entry -> FORM_SYMBOLS.test((AbstractSymbol)entry.getValue())).collect(Collectors.toList());
    }

    public List<Map.Entry<String, AbstractSymbol>> affectAndElementSymbols() {
        return this.symbols.entrySet().stream().filter(entry -> AFFECT_SYMBOLS.or(ELEMENT_SYMBOLS).test((AbstractSymbol)entry.getValue())).collect(Collectors.toList());
    }
}

