/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.macos.foundation;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import de.maxhenkel.voicechat.macos.foundation.Foundation;
import de.maxhenkel.voicechat.macos.foundation.NSObject;

public class NSString
extends NSObject {
    private static final Pointer nativeClass = Foundation.INSTANCE.objc_getClass("NSString");
    private static final Pointer stringWithUTF8StringSelector = Foundation.INSTANCE.sel_registerName("stringWithUTF8String:");

    public NSString(String javaString) {
        super(NSString.getNativeString(javaString));
    }

    public NSString(NativeLong id) {
        super(id);
    }

    private static NativeLong getNativeString(String javaString) {
        return Foundation.INSTANCE.objc_msgSend(nativeClass, stringWithUTF8StringSelector, javaString);
    }

    public String toString() {
        return this.getJVMString();
    }

    public String getJVMString() {
        return this.getCFStringRef().stringValue();
    }

    public CoreFoundation.CFStringRef getCFStringRef() {
        return new CoreFoundation.CFStringRef(new Pointer(this.getId().longValue()));
    }
}

