/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.RawUdpPacket;
import de.maxhenkel.voicechat.api.VoicechatSocket;
import de.maxhenkel.voicechat.debug.CooldownTimer;
import de.maxhenkel.voicechat.debug.VoicechatUncaughtExceptionHandler;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.ConnectionCheckAckPacket;
import de.maxhenkel.voicechat.voice.common.ConnectionCheckPacket;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import de.maxhenkel.voicechat.voice.server.ServerCategoryManager;
import de.maxhenkel.voicechat.voice.server.ServerGroupManager;
import de.maxhenkel.voicechat.voice.server.ServerWorldUtils;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_3176;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Server
extends Thread {
    private final Map<UUID, ClientConnection> connections;
    private final Map<UUID, ClientConnection> unCheckedConnections;
    private final Map<UUID, UUID> secrets;
    private final boolean dedicated;
    private int port;
    private final MinecraftServer server;
    private VoicechatSocket socket;
    private final ProcessThread processThread;
    private final BlockingQueue<RawUdpPacket> packetQueue;
    private final PingManager pingManager;
    private final PlayerStateManager playerStateManager;
    private final ServerGroupManager groupManager;
    private final ServerCategoryManager categoryManager;

    public Server(MinecraftServer server) {
        this.dedicated = server instanceof class_3176;
        if (this.dedicated) {
            int configPort = Voicechat.SERVER_CONFIG.voiceChatPort.get();
            if (configPort < 0) {
                Voicechat.LOGGER.info("Using the Minecraft servers port as voice chat port", new Object[0]);
                this.port = server.method_3756();
            } else {
                this.port = configPort;
            }
        } else {
            this.port = 0;
        }
        this.server = server;
        this.socket = PluginManager.instance().getSocketImplementation(server);
        this.connections = new ConcurrentHashMap<UUID, ClientConnection>();
        this.unCheckedConnections = new ConcurrentHashMap<UUID, ClientConnection>();
        this.secrets = new ConcurrentHashMap<UUID, UUID>();
        this.packetQueue = new LinkedBlockingQueue<RawUdpPacket>();
        this.pingManager = new PingManager(this);
        this.playerStateManager = new PlayerStateManager(this);
        this.groupManager = new ServerGroupManager(this);
        this.categoryManager = new ServerCategoryManager(this);
        this.setDaemon(true);
        this.setName("VoiceChatServerThread");
        this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
        this.processThread = new ProcessThread();
        this.processThread.start();
    }

    public void onPlayerLoggedIn(class_3222 player) {
        this.playerStateManager.onPlayerLoggedIn(player);
    }

    public void onPlayerLoggedOut(class_3222 player) {
        this.disconnectClient(player.method_5667());
        this.playerStateManager.onPlayerLoggedOut(player);
        this.groupManager.onPlayerLoggedOut(player);
    }

    public void onPlayerVoicechatConnect(class_3222 player) {
        this.playerStateManager.onPlayerVoicechatConnect(player);
    }

    public void onPlayerVoicechatDisconnect(UUID uuid) {
        this.playerStateManager.onPlayerVoicechatDisconnect(uuid);
    }

    public void onPlayerCompatibilityCheckSucceeded(class_3222 player) {
        this.playerStateManager.onPlayerCompatibilityCheckSucceeded(player);
        this.groupManager.onPlayerCompatibilityCheckSucceeded(player);
        this.categoryManager.onPlayerCompatibilityCheckSucceeded(player);
    }

    @Override
    public void run() {
        try {
            String bindAddress = this.getBindAddress();
            try {
                InetAddress.getByName(bindAddress);
            }
            catch (UnknownHostException e) {
                Voicechat.LOGGER.error("Failed to parse bind IP address '{}'", bindAddress, e);
                Voicechat.LOGGER.info("Binding to wildcard IP address", new Object[0]);
                bindAddress = "";
            }
            this.socket.open(this.port, bindAddress);
            if (bindAddress.isEmpty()) {
                Voicechat.LOGGER.info("Voice chat server started at port {}", this.socket.getLocalPort());
            } else {
                Voicechat.LOGGER.info("Voice chat server started at {}:{}", bindAddress, this.socket.getLocalPort());
            }
            while (!this.socket.isClosed()) {
                try {
                    this.packetQueue.add(this.socket.read());
                }
                catch (Exception e) {
                    if (e instanceof SocketException && e.getCause() instanceof AsynchronousCloseException || !Voicechat.debugMode()) continue;
                    Voicechat.LOGGER.error("Failed to read from socket", e);
                }
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Voice chat server error", e);
        }
    }

    private String getBindAddress() {
        if (!this.dedicated) {
            return "";
        }
        String bindAddress = Voicechat.SERVER_CONFIG.voiceChatBindAddress.get();
        if (bindAddress.trim().equals("*")) {
            bindAddress = "";
        } else if (bindAddress.trim().isEmpty() && this.server instanceof class_3176 && !(bindAddress = ((class_3176)this.server).method_16705().field_16829).trim().isEmpty()) {
            try {
                InetAddress address = InetAddress.getByName(bindAddress);
                if (address.isLoopbackAddress()) {
                    bindAddress = "";
                } else {
                    Voicechat.LOGGER.info("Using server-ip as bind address: {}", bindAddress);
                }
            }
            catch (Exception e) {
                Voicechat.LOGGER.warn("Invalid server-ip", e);
                bindAddress = "";
            }
        }
        return bindAddress;
    }

    public void changePort(int port) throws Exception {
        VoicechatSocket newSocket = PluginManager.instance().getSocketImplementation(this.server);
        newSocket.open(port, this.getBindAddress());
        VoicechatSocket old = this.socket;
        this.socket = newSocket;
        this.port = port;
        old.close();
        this.connections.clear();
        this.unCheckedConnections.clear();
        this.secrets.clear();
    }

    public UUID getSecret(UUID playerUUID) {
        if (this.hasSecret(playerUUID)) {
            return this.secrets.get(playerUUID);
        }
        SecureRandom r = new SecureRandom();
        UUID secret = new UUID(r.nextLong(), r.nextLong());
        this.secrets.put(playerUUID, secret);
        return secret;
    }

    @Nullable
    public UUID generateNewSecret(UUID playerUUID) {
        if (this.hasSecret(playerUUID)) {
            return null;
        }
        return this.getSecret(playerUUID);
    }

    public boolean hasSecret(UUID playerUUID) {
        return this.secrets.containsKey(playerUUID);
    }

    public void disconnectClient(UUID playerUUID) {
        this.connections.remove(playerUUID);
        this.unCheckedConnections.remove(playerUUID);
        this.secrets.remove(playerUUID);
        PluginManager.instance().onPlayerDisconnected(playerUUID);
    }

    public void close() {
        this.socket.close();
        this.processThread.close();
        PluginManager.instance().onServerStopped();
    }

    public boolean isClosed() {
        return !this.processThread.running;
    }

    public void onMicPacket(UUID playerUuid, MicPacket packet) {
        class_3222 player = this.server.method_3760().method_14602(playerUuid);
        if (player == null) {
            return;
        }
        if (!PermissionManager.INSTANCE.SPEAK_PERMISSION.hasPermission(player)) {
            CooldownTimer.run("no-speak-" + playerUuid, 30000L, () -> player.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.no_speak_permission"), true));
            return;
        }
        PlayerState state = this.playerStateManager.getState(player.method_5667());
        if (state == null) {
            return;
        }
        if (!PluginManager.instance().onMicPacket(player, state, packet)) {
            this.processMicPacket(player, state, packet);
        }
    }

    private void processMicPacket(class_3222 player, PlayerState state, MicPacket packet) {
        if (state.hasGroup()) {
            Group group = this.groupManager.getGroup(state.getGroup());
            this.processGroupPacket(state, player, packet);
            if (group == null || group.isOpen()) {
                this.processProximityPacket(state, player, packet);
            }
            return;
        }
        this.processProximityPacket(state, player, packet);
    }

    private void processGroupPacket(PlayerState senderState, class_3222 sender, MicPacket packet) {
        UUID groupId = senderState.getGroup();
        if (groupId == null) {
            return;
        }
        GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getUuid(), senderState.getUuid(), packet.getData(), packet.getSequenceNumber(), null);
        for (PlayerState state : this.playerStateManager.getStates()) {
            class_3222 p;
            if (!groupId.equals(state.getGroup()) || senderState.getUuid().equals(state.getUuid()) || (p = this.server.method_3760().method_14602(state.getUuid())) == null) continue;
            ClientConnection connection = this.getConnection(state.getUuid());
            this.sendSoundPacket(sender, senderState, p, state, connection, groupSoundPacket, "group");
        }
    }

    private void processProximityPacket(PlayerState senderState, class_3222 sender, MicPacket packet) {
        UUID groupId = senderState.getGroup();
        float distance = Utils.getDefaultDistanceServer();
        SoundPacket soundPacket = null;
        String source = null;
        if (sender.method_7325()) {
            class_3222 spectatingPlayer;
            class_1297 camera;
            if (Voicechat.SERVER_CONFIG.spectatorPlayerPossession.get().booleanValue() && (camera = sender.method_14242()) instanceof class_3222 && (spectatingPlayer = (class_3222)camera) != sender) {
                PlayerState receiverState = this.playerStateManager.getState(spectatingPlayer.method_5667());
                if (receiverState == null) {
                    return;
                }
                GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getUuid(), senderState.getUuid(), packet.getData(), packet.getSequenceNumber(), null);
                ClientConnection connection = this.getConnection(receiverState.getUuid());
                this.sendSoundPacket(sender, senderState, spectatingPlayer, receiverState, connection, groupSoundPacket, "spectator");
                return;
            }
            if (Voicechat.SERVER_CONFIG.spectatorInteraction.get().booleanValue()) {
                soundPacket = new LocationSoundPacket(sender.method_5667(), sender.method_5667(), sender.method_33571(), packet.getData(), packet.getSequenceNumber(), distance, null);
                source = "spectator";
            }
        }
        if (soundPacket == null) {
            float crouchMultiplayer = sender.method_18276() ? Voicechat.SERVER_CONFIG.crouchDistanceMultiplier.get().floatValue() : 1.0f;
            float whisperMultiplayer = packet.isWhispering() ? Voicechat.SERVER_CONFIG.whisperDistanceMultiplier.get().floatValue() : 1.0f;
            float multiplier = crouchMultiplayer * whisperMultiplayer;
            soundPacket = new PlayerSoundPacket(sender.method_5667(), sender.method_5667(), packet.getData(), packet.getSequenceNumber(), packet.isWhispering(), distance *= multiplier, null);
            source = "proximity";
        }
        this.broadcast(ServerWorldUtils.getPlayersInRange(sender.method_14220(), sender.method_19538(), this.getBroadcastRange(distance), p -> !p.method_5667().equals(sender.method_5667())), soundPacket, sender, senderState, groupId, source);
    }

    public void sendSoundPacket(@Nullable class_3222 sender, @Nullable PlayerState senderState, class_3222 receiver, PlayerState receiverState, @Nullable ClientConnection connection, SoundPacket<?> soundPacket, String source) {
        PluginManager.instance().onListenerAudio(receiver.method_5667(), soundPacket);
        if (connection == null) {
            return;
        }
        if (receiverState.isDisabled() || receiverState.isDisconnected()) {
            return;
        }
        if (PluginManager.instance().onSoundPacket(sender, senderState, receiver, receiverState, soundPacket, source)) {
            return;
        }
        if (!PermissionManager.INSTANCE.LISTEN_PERMISSION.hasPermission(receiver)) {
            CooldownTimer.run(String.format("no-listen-%s", receiver.method_5667()), 30000L, () -> receiver.method_7353((class_2561)class_2561.method_43471((String)"message.voicechat.no_listen_permission"), true));
            return;
        }
        this.sendPacket(soundPacket, connection);
    }

    public double getBroadcastRange(float minRange) {
        double broadcastRange = Voicechat.SERVER_CONFIG.broadcastRange.get();
        if (broadcastRange < 0.0) {
            broadcastRange = Voicechat.SERVER_CONFIG.voiceChatDistance.get() + 1.0;
        }
        return Math.max(broadcastRange, (double)minRange);
    }

    public void broadcast(Collection<class_3222> players, SoundPacket<?> packet, @Nullable class_3222 sender, @Nullable PlayerState senderState, @Nullable UUID groupId, String source) {
        for (class_3222 player : players) {
            PlayerState state = this.playerStateManager.getState(player.method_5667());
            if (state == null || state.hasGroup() && state.getGroup().equals(groupId)) continue;
            Group receiverGroup = null;
            if (state.hasGroup()) {
                receiverGroup = this.groupManager.getGroup(state.getGroup());
            }
            if (receiverGroup != null && receiverGroup.isIsolated()) continue;
            ClientConnection connection = this.getConnection(state.getUuid());
            this.sendSoundPacket(sender, senderState, player, state, connection, packet, source);
        }
    }

    private void sendKeepAlives() {
        long timestamp = System.currentTimeMillis();
        this.connections.values().removeIf(connection -> {
            if (timestamp - connection.getLastKeepAliveResponse() >= (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue() * 10L) {
                this.secrets.remove(connection.getPlayerUUID());
                Voicechat.LOGGER.info("Player {} timed out", connection.getPlayerUUID());
                class_3222 player = this.server.method_3760().method_14602(connection.getPlayerUUID());
                if (player != null) {
                    Voicechat.LOGGER.info("Reconnecting player {}", player.method_5477().getString());
                    Voicechat.SERVER.initializePlayerConnection(player);
                } else {
                    Voicechat.LOGGER.warn("Reconnecting player {} failed (Could not find player)", connection.getPlayerUUID());
                }
                CommonCompatibilityManager.INSTANCE.emitServerVoiceChatDisconnectedEvent(connection.getPlayerUUID());
                PluginManager.instance().onPlayerDisconnected(connection.getPlayerUUID());
                return true;
            }
            return false;
        });
        for (ClientConnection connection2 : this.connections.values()) {
            this.sendPacket(new KeepAlivePacket(), connection2);
        }
    }

    @Nullable
    public ClientConnection getSender(NetworkMessage message) {
        return this.connections.values().stream().filter(connection -> connection.getAddress().equals(message.getAddress())).findAny().orElse(null);
    }

    @Nullable
    public ClientConnection getUnconnectedSender(NetworkMessage message) {
        return this.unCheckedConnections.values().stream().filter(connection -> connection.getAddress().equals(message.getAddress())).findAny().orElse(null);
    }

    public Map<UUID, ClientConnection> getConnections() {
        return this.connections;
    }

    @Nullable
    public ClientConnection getConnection(UUID playerID) {
        return this.connections.get(playerID);
    }

    public VoicechatSocket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public boolean sendPacket(Packet<?> packet, ClientConnection connection) {
        try {
            this.sendPacketRaw(packet, connection);
            return true;
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to send voice chat packet to {}", connection.getPlayerUUID());
            return false;
        }
    }

    public void sendPacketRaw(Packet<?> packet, ClientConnection connection) throws Exception {
        connection.send(this, new NetworkMessage(packet));
    }

    public PingManager getPingManager() {
        return this.pingManager;
    }

    public PlayerStateManager getPlayerStateManager() {
        return this.playerStateManager;
    }

    public ServerGroupManager getGroupManager() {
        return this.groupManager;
    }

    public ServerCategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    private class ProcessThread
    extends Thread {
        private boolean running = true;
        private long lastKeepAlive = 0L;

        public ProcessThread() {
            this.setDaemon(true);
            this.setName("VoiceChatPacketProcessingThread");
            this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    AuthenticatePacket packet;
                    UUID secret;
                    NetworkMessage message;
                    RawUdpPacket rawPacket;
                    Server.this.pingManager.checkTimeouts();
                    long keepAliveTime = System.currentTimeMillis();
                    if (keepAliveTime - this.lastKeepAlive > (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue()) {
                        Server.this.sendKeepAlives();
                        this.lastKeepAlive = keepAliveTime;
                    }
                    if ((rawPacket = Server.this.packetQueue.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                    try {
                        message = NetworkMessage.readPacketServer(rawPacket, Server.this);
                    }
                    catch (Exception e) {
                        CooldownTimer.run("failed_reading_packet", () -> Voicechat.LOGGER.warn("Failed to read packet from {}", rawPacket.getSocketAddress()));
                        continue;
                    }
                    if (message == null) continue;
                    if (System.currentTimeMillis() - message.getTimestamp() > message.getTTL()) {
                        CooldownTimer.run("ttl", () -> {
                            Voicechat.LOGGER.warn("Dropping voice chat packets! Your Server might be overloaded!", new Object[0]);
                            Voicechat.LOGGER.warn("Packet queue has {} packets", Server.this.packetQueue.size());
                        });
                        continue;
                    }
                    Packet<? extends Packet> packet2 = message.getPacket();
                    if (packet2 instanceof AuthenticatePacket && (secret = Server.this.secrets.get((packet = (AuthenticatePacket)packet2).getPlayerUUID())) != null && secret.equals(packet.getSecret())) {
                        ClientConnection connection = Server.this.unCheckedConnections.get(packet.getPlayerUUID());
                        if (connection == null) {
                            connection = Server.this.connections.get(packet.getPlayerUUID());
                        }
                        if (connection == null) {
                            connection = new ClientConnection(packet.getPlayerUUID(), message.getAddress());
                            Server.this.unCheckedConnections.put(packet.getPlayerUUID(), connection);
                            Voicechat.LOGGER.info("Successfully authenticated player {}", packet.getPlayerUUID());
                        }
                        Server.this.sendPacket(new AuthenticateAckPacket(), connection);
                    }
                    if (message.getPacket() instanceof ConnectionCheckPacket) {
                        ClientConnection connection = Server.this.getUnconnectedSender(message);
                        if (connection == null) {
                            connection = Server.this.getSender(message);
                            if (connection == null) continue;
                            Server.this.sendPacket(new ConnectionCheckAckPacket(), connection);
                            continue;
                        }
                        connection.setLastKeepAliveResponse(System.currentTimeMillis());
                        Server.this.connections.put(connection.getPlayerUUID(), connection);
                        Server.this.unCheckedConnections.remove(connection.getPlayerUUID());
                        Voicechat.LOGGER.info("Successfully validated connection of player {}", connection.getPlayerUUID());
                        class_3222 player = Server.this.server.method_3760().method_14602(connection.getPlayerUUID());
                        if (player != null) {
                            CommonCompatibilityManager.INSTANCE.emitServerVoiceChatConnectedEvent(player);
                            PluginManager.instance().onPlayerConnected(player);
                            Voicechat.LOGGER.info("Player {} ({}) successfully connected to voice chat", player.method_5477().getString(), connection.getPlayerUUID());
                        }
                        Server.this.sendPacket(new ConnectionCheckAckPacket(), connection);
                        continue;
                    }
                    ClientConnection conn = Server.this.getSender(message);
                    if (conn == null) continue;
                    Packet<? extends Packet> packet3 = message.getPacket();
                    if (packet3 instanceof MicPacket) {
                        MicPacket packet4 = (MicPacket)packet3;
                        Server.this.onMicPacket(conn.getPlayerUUID(), packet4);
                        continue;
                    }
                    packet3 = message.getPacket();
                    if (packet3 instanceof PingPacket) {
                        PingPacket packet5 = (PingPacket)packet3;
                        Server.this.pingManager.onPongPacket(packet5);
                        continue;
                    }
                    if (!(message.getPacket() instanceof KeepAlivePacket)) continue;
                    conn.setLastKeepAliveResponse(System.currentTimeMillis());
                }
                catch (Exception e) {
                    Voicechat.LOGGER.error("Voice chat server error", e);
                }
            }
        }

        public void close() {
            this.running = false;
        }
    }
}

