/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.plugins.impl.GroupImpl;
import de.maxhenkel.voicechat.plugins.impl.ServerPlayerImpl;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import de.maxhenkel.voicechat.voice.server.Server;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class VoicechatConnectionImpl
implements VoicechatConnection {
    private final ServerPlayer player;
    private final Player serverPlayer;
    private final PlayerState state;
    @Nullable
    private final de.maxhenkel.voicechat.api.Group group;

    public VoicechatConnectionImpl(Player player, PlayerState state) {
        this.serverPlayer = player;
        this.player = new ServerPlayerImpl(player);
        this.state = state;
        this.group = GroupImpl.create(state);
    }

    @Nullable
    public static VoicechatConnectionImpl fromPlayer(@Nullable Player player) {
        if (player == null) {
            return null;
        }
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return null;
        }
        PlayerState state = server.getPlayerStateManager().getState(player.getUniqueId());
        if (state == null) {
            return null;
        }
        return new VoicechatConnectionImpl(player, state);
    }

    @Override
    @Nullable
    public de.maxhenkel.voicechat.api.Group getGroup() {
        return this.group;
    }

    @Override
    public boolean isInGroup() {
        return this.group != null;
    }

    @Override
    public void setGroup(@Nullable de.maxhenkel.voicechat.api.Group group) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return;
        }
        if (group == null) {
            server.getGroupManager().leaveGroup((Player)this.player.getPlayer());
            return;
        }
        if (group instanceof GroupImpl) {
            GroupImpl g = (GroupImpl)group;
            Group actualGroup = server.getGroupManager().getGroup(g.getGroup().getId());
            if (actualGroup == null) {
                server.getGroupManager().addGroup(g.getGroup(), this.serverPlayer);
                actualGroup = g.getGroup();
            }
            server.getGroupManager().joinGroup(actualGroup, this.serverPlayer, g.getGroup().getPassword());
        }
    }

    @Override
    public boolean isConnected() {
        return !this.state.isDisconnected();
    }

    @Override
    public void setConnected(boolean connected) {
        if (this.isInstalled()) {
            return;
        }
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return;
        }
        PlayerStateManager manager = server.getPlayerStateManager();
        PlayerState actualState = manager.getState(this.state.getUuid());
        if (actualState == null) {
            return;
        }
        if (actualState.isDisconnected() != connected) {
            return;
        }
        actualState.setDisconnected(!connected);
        manager.broadcastState(actualState);
    }

    @Override
    public boolean isDisabled() {
        return this.state.isDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.isInstalled()) {
            return;
        }
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return;
        }
        PlayerStateManager manager = server.getPlayerStateManager();
        PlayerState actualState = manager.getState(this.state.getUuid());
        if (actualState == null) {
            return;
        }
        if (actualState.isDisabled() == disabled) {
            return;
        }
        actualState.setDisabled(disabled);
        manager.broadcastState(actualState);
    }

    @Override
    public boolean isInstalled() {
        return Voicechat.SERVER.isCompatible(this.serverPlayer);
    }

    @Override
    public ServerPlayer getPlayer() {
        return this.player;
    }
}

