/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.AddGroupPacket;
import de.maxhenkel.voicechat.net.CreateGroupPacket;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.JoinedGroupPacket;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.RemoveGroupPacket;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerQuitEvent;

public class ServerGroupManager {
    private final Map<UUID, Group> groups = new ConcurrentHashMap<UUID, Group>();

    public void onJoinGroupPacket(Player player, JoinGroupPacket packet) {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            return;
        }
        if (!player.hasPermission(PermissionManager.GROUPS_PERMISSION)) {
            NetManager.sendStatusMessage(player, "message.voicechat.no_group_permission", new String[0]);
            return;
        }
        this.joinGroup(this.groups.get(packet.getGroup()), player, packet.getPassword());
    }

    public void onCreateGroupPacket(Player player, CreateGroupPacket packet) {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            return;
        }
        if (!player.hasPermission(PermissionManager.GROUPS_PERMISSION)) {
            NetManager.sendStatusMessage(player, "message.voicechat.no_group_permission", new String[0]);
            return;
        }
        if (!Voicechat.GROUP_REGEX.matcher(packet.getName()).matches()) {
            Voicechat.LOGGER.warn("Player {} tried to create a group with an invalid name: {}", player.getDisplayName(), packet.getName());
            return;
        }
        Group group = new Group(UUID.randomUUID(), packet.getName(), packet.getPassword(), false, false, packet.getType());
        this.addGroup(group, player);
    }

    public void onLeaveGroupPacket(Player player, LeaveGroupPacket packet) {
        this.leaveGroup(player);
    }

    public void onPlayerCompatibilityCheckSucceeded(Player player) {
        Voicechat.LOGGER.debug("Synchronizing {} groups with {}", this.groups.size(), player.getDisplayName());
        for (Group category : this.groups.values()) {
            this.broadcastAddGroup(category);
        }
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        this.cleanupGroups();
    }

    private PlayerStateManager getStates() {
        return Voicechat.SERVER.getServer().getPlayerStateManager();
    }

    public void addGroup(Group group, @Nullable Player player) {
        if (PluginManager.instance().onCreateGroup(player, group)) {
            return;
        }
        this.groups.put(group.getId(), group);
        this.broadcastAddGroup(group);
        if (player == null) {
            return;
        }
        PlayerStateManager manager = this.getStates();
        manager.setGroup(player, group.getId());
        NetManager.sendToClient(player, new JoinedGroupPacket(group.getId(), false));
    }

    public void joinGroup(@Nullable Group group, Player player, String password) {
        if (PluginManager.instance().onJoinGroup(player, group)) {
            return;
        }
        if (group == null) {
            NetManager.sendToClient(player, new JoinedGroupPacket(null, false));
            return;
        }
        if (group.getPassword() != null && !group.getPassword().equals(password)) {
            NetManager.sendToClient(player, new JoinedGroupPacket(null, true));
            return;
        }
        PlayerStateManager manager = this.getStates();
        manager.setGroup(player, group.getId());
        NetManager.sendToClient(player, new JoinedGroupPacket(group.getId(), false));
    }

    public void leaveGroup(Player player) {
        if (PluginManager.instance().onLeaveGroup(player)) {
            return;
        }
        PlayerStateManager manager = this.getStates();
        manager.setGroup(player, null);
        NetManager.sendToClient(player, new JoinedGroupPacket(null, false));
        this.cleanupGroups();
    }

    public void cleanupGroups() {
        PlayerStateManager manager = this.getStates();
        List usedGroups = manager.getStates().stream().filter(PlayerState::hasGroup).map(PlayerState::getGroup).distinct().collect(Collectors.toList());
        List groupsToRemove = this.groups.entrySet().stream().filter(entry -> !((Group)entry.getValue()).isPersistent()).map(Map.Entry::getKey).filter(uuid -> !usedGroups.contains(uuid)).collect(Collectors.toList());
        for (UUID uuid2 : groupsToRemove) {
            this.removeGroup(uuid2);
        }
    }

    public boolean removeGroup(UUID groupId) {
        Group group = this.groups.get(groupId);
        if (group == null) {
            return false;
        }
        PlayerStateManager manager = this.getStates();
        if (manager.getStates().stream().anyMatch(state -> state.hasGroup() && state.getGroup().equals(groupId))) {
            return false;
        }
        if (PluginManager.instance().onRemoveGroup(group)) {
            return false;
        }
        this.groups.remove(groupId);
        this.broadcastRemoveGroup(groupId);
        return true;
    }

    @Nullable
    public Group getGroup(UUID groupID) {
        return this.groups.get(groupID);
    }

    private void broadcastAddGroup(Group group) {
        AddGroupPacket packet = new AddGroupPacket(group.toClientGroup());
        Voicechat.INSTANCE.getServer().getOnlinePlayers().forEach(p -> NetManager.sendToClient(p, packet));
    }

    private void broadcastRemoveGroup(UUID group) {
        RemoveGroupPacket packet = new RemoveGroupPacket(group);
        Voicechat.INSTANCE.getServer().getOnlinePlayers().forEach(p -> NetManager.sendToClient(p, packet));
    }

    public Map<UUID, Group> getGroups() {
        return this.groups;
    }
}

