/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.ClientVoicechatSocket;
import de.maxhenkel.voicechat.api.events.ClientReceiveSoundEvent;
import de.maxhenkel.voicechat.api.events.ClientSoundEvent;
import de.maxhenkel.voicechat.api.events.ClientVoicechatInitializationEvent;
import de.maxhenkel.voicechat.api.events.CreateOpenALContextEvent;
import de.maxhenkel.voicechat.api.events.DestroyOpenALContextEvent;
import de.maxhenkel.voicechat.api.events.MergeClientSoundEvent;
import de.maxhenkel.voicechat.api.events.NameTagIconRenderEvent;
import de.maxhenkel.voicechat.api.events.OpenALSoundEvent;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.plugins.impl.ClientVoicechatSocketImpl;
import de.maxhenkel.voicechat.plugins.impl.PositionImpl;
import de.maxhenkel.voicechat.plugins.impl.events.ClientReceiveSoundEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.ClientSoundEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.ClientVoicechatInitializationEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.CreateOpenALContextEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.DestroyOpenALContextEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.MergeClientSoundEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.NameTagIconRenderEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.OpenALSoundEventImpl;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_243;

public class ClientPluginManager {
    private final PluginManager pluginManager;
    private final NameTagIconRenderEventImpl cachedRenderEvent = new NameTagIconRenderEventImpl();
    private static ClientPluginManager instance;

    public ClientPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public boolean shouldRenderPlayerIcons(UUID entityId) {
        this.cachedRenderEvent.setEntityId(entityId);
        this.cachedRenderEvent.setCancelled(false);
        return !this.pluginManager.dispatchEvent(NameTagIconRenderEvent.class, this.cachedRenderEvent);
    }

    public ClientVoicechatSocket getClientSocketImplementation() {
        ClientVoicechatInitializationEventImpl event = new ClientVoicechatInitializationEventImpl();
        this.pluginManager.dispatchEvent(ClientVoicechatInitializationEvent.class, event);
        ClientVoicechatSocket socket = event.getSocketImplementation();
        if (socket == null) {
            socket = new ClientVoicechatSocketImpl();
            Voicechat.LOGGER.debug("Using default voicechat client socket implementation", new Object[0]);
        } else {
            Voicechat.LOGGER.info("Using custom voicechat client socket implementation: {}", socket.getClass().getName());
        }
        return socket;
    }

    @Nullable
    public short[] onMergeClientSound(@Nullable short[] rawAudio) {
        MergeClientSoundEventImpl event = new MergeClientSoundEventImpl();
        this.pluginManager.dispatchEvent(MergeClientSoundEvent.class, event);
        List<short[]> audioToMerge = event.getAudioToMerge();
        if (audioToMerge == null) {
            return rawAudio;
        }
        if (rawAudio != null) {
            audioToMerge.add(0, rawAudio);
        }
        return AudioUtils.combineAudio(audioToMerge);
    }

    @Nullable
    public short[] onClientSound(short[] rawAudio, boolean whispering) {
        ClientSoundEventImpl clientSoundEvent = new ClientSoundEventImpl(rawAudio, whispering);
        boolean cancelled = this.pluginManager.dispatchEvent(ClientSoundEvent.class, clientSoundEvent);
        if (cancelled) {
            return null;
        }
        return clientSoundEvent.getRawAudio();
    }

    public short[] onReceiveEntityClientSound(UUID id, UUID entity, short[] rawAudio, boolean whispering, float distance) {
        ClientReceiveSoundEventImpl.EntitySoundImpl clientSoundEvent = new ClientReceiveSoundEventImpl.EntitySoundImpl(id, entity, rawAudio, whispering, distance);
        this.pluginManager.dispatchEvent(ClientReceiveSoundEvent.EntitySound.class, clientSoundEvent);
        return clientSoundEvent.getRawAudio();
    }

    public short[] onReceiveLocationalClientSound(UUID id, short[] rawAudio, class_243 pos, float distance) {
        ClientReceiveSoundEventImpl.LocationalSoundImpl clientSoundEvent = new ClientReceiveSoundEventImpl.LocationalSoundImpl(id, rawAudio, new PositionImpl(pos), distance);
        this.pluginManager.dispatchEvent(ClientReceiveSoundEvent.LocationalSound.class, clientSoundEvent);
        return clientSoundEvent.getRawAudio();
    }

    public short[] onReceiveStaticClientSound(UUID id, short[] rawAudio) {
        ClientReceiveSoundEventImpl.StaticSoundImpl clientSoundEvent = new ClientReceiveSoundEventImpl.StaticSoundImpl(id, rawAudio);
        this.pluginManager.dispatchEvent(ClientReceiveSoundEvent.StaticSound.class, clientSoundEvent);
        return clientSoundEvent.getRawAudio();
    }

    public void onALSound(int source, @Nullable UUID channelId, @Nullable class_243 pos, @Nullable String category, Class<? extends OpenALSoundEvent> eventClass) {
        this.pluginManager.dispatchEvent(eventClass, new OpenALSoundEventImpl(channelId, pos == null ? null : new PositionImpl(pos), category, source));
    }

    public void onCreateALContext(long context, long device) {
        this.pluginManager.dispatchEvent(CreateOpenALContextEvent.class, new CreateOpenALContextEventImpl(context, device));
    }

    public void onDestroyALContext(long context, long device) {
        this.pluginManager.dispatchEvent(DestroyOpenALContextEvent.class, new DestroyOpenALContextEventImpl(context, device));
    }

    public static ClientPluginManager instance() {
        if (instance == null) {
            instance = new ClientPluginManager(PluginManager.instance());
        }
        return instance;
    }
}

