/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.lame4j;

import de.maxhenkel.lame4j.Audio;
import de.maxhenkel.lame4j.DecodedAudio;
import de.maxhenkel.lame4j.NativeInitializer;
import de.maxhenkel.lame4j.ShortArrayBuffer;
import de.maxhenkel.lame4j.UnknownPlatformException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;

public class Mp3Decoder
implements Audio,
AutoCloseable {
    private long pointer;
    private final InputStream inputStream;
    private final byte[] inBuffer;
    private final byte[] leftoverBuffer;
    private int leftoverBufferLength;
    private final short[] outBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mp3Decoder(InputStream inputStream) throws IOException, UnknownPlatformException {
        Class<Mp3Decoder> clazz = Mp3Decoder.class;
        synchronized (Mp3Decoder.class) {
            NativeInitializer.load("liblame4j");
            this.pointer = Mp3Decoder.createDecoder0();
            this.inputStream = inputStream;
            this.inBuffer = new byte[16384];
            this.leftoverBuffer = new byte[16384];
            this.leftoverBufferLength = 0;
            this.outBuffer = new short[Mp3Decoder.getMaxSamplesPerFrame0()];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static native long createDecoder0();

    private static native int getMaxSamplesPerFrame0();

    private native long decodeNextFrame0(long var1, byte[] var3, int var4, short[] var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] decodeNextFrame() throws IOException {
        Mp3Decoder mp3Decoder = this;
        synchronized (mp3Decoder) {
            System.arraycopy(this.leftoverBuffer, 0, this.inBuffer, 0, this.leftoverBufferLength);
            int bytesRead = this.inputStream.read(this.inBuffer, this.leftoverBufferLength, this.inBuffer.length - this.leftoverBufferLength);
            if (bytesRead < 0) {
                if (this.leftoverBufferLength <= 0) {
                    return null;
                }
                bytesRead = 0;
            }
            int bytesToUse = this.leftoverBufferLength + bytesRead;
            long result = this.decodeNextFrame0(this.pointer, this.inBuffer, bytesToUse, this.outBuffer);
            int samplesDecoded = (int)(result >> 32);
            int bytesToAdvance = (int)result;
            short[] samples = new short[samplesDecoded];
            System.arraycopy(this.outBuffer, 0, samples, 0, samplesDecoded);
            this.leftoverBufferLength = bytesToUse - bytesToAdvance;
            System.arraycopy(this.inBuffer, bytesToAdvance, this.leftoverBuffer, 0, this.leftoverBufferLength);
            return samples;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean headerParsed() {
        Mp3Decoder mp3Decoder = this;
        synchronized (mp3Decoder) {
            return this.getChannelCount0(this.pointer) >= 0 && this.getSampleRate0(this.pointer) >= 0 && this.getBitRate0(this.pointer) >= 0;
        }
    }

    private native int getChannelCount0(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChannelCount() {
        Mp3Decoder mp3Decoder = this;
        synchronized (mp3Decoder) {
            return this.getChannelCount0(this.pointer);
        }
    }

    private native int getBitRate0(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBitRate() {
        Mp3Decoder mp3Decoder = this;
        synchronized (mp3Decoder) {
            return this.getBitRate0(this.pointer);
        }
    }

    private native int getSampleRate0(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSampleRate() {
        Mp3Decoder mp3Decoder = this;
        synchronized (mp3Decoder) {
            return this.getSampleRate0(this.pointer);
        }
    }

    @Override
    @Nullable
    public AudioFormat createAudioFormat() {
        if (!this.headerParsed()) {
            return null;
        }
        return Audio.super.createAudioFormat();
    }

    private native void destroyDecoder0(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Mp3Decoder mp3Decoder = this;
        synchronized (mp3Decoder) {
            this.destroyDecoder0(this.pointer);
            this.pointer = 0L;
            this.inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Mp3Decoder mp3Decoder = this;
        synchronized (mp3Decoder) {
            return this.pointer == 0L;
        }
    }

    public static DecodedAudio decode(InputStream inputStream) throws IOException, UnknownPlatformException {
        try (Mp3Decoder decoder = new Mp3Decoder(inputStream);){
            ShortArrayBuffer sampleBuffer = new ShortArrayBuffer(2048);
            while (true) {
                short[] samples;
                if ((samples = decoder.decodeNextFrame()) == null) {
                    if (sampleBuffer.size() > 0) break;
                    throw new IOException("No audio data found");
                }
                sampleBuffer.writeShorts(samples);
            }
            if (!decoder.headerParsed()) {
                throw new IOException("No header found");
            }
            DecodedAudio decodedAudio = new DecodedAudio(decoder.getChannelCount(), decoder.getSampleRate(), decoder.getBitRate(), sampleBuffer.toShortArray());
            return decodedAudio;
        }
    }
}

