/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.group.GroupEntry;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;

public class GroupList
extends ListScreenListBase<GroupEntry> {
    protected final ListScreenBase parent;

    public GroupList(ListScreenBase parent, int width, int height, int top, int itemSize) {
        super(width, height, top, itemSize);
        this.parent = parent;
        this.updateMembers();
    }

    public void updateMembers() {
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates(true);
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            this.clearEntries();
            this.minecraft.setScreen(null);
            return;
        }
        boolean changed = false;
        LinkedList<GroupEntry> toRemove = new LinkedList<GroupEntry>();
        for (GroupEntry entry : this.children()) {
            PlayerState state = ClientManager.getPlayerStateManager().getState(entry.getState().getUuid());
            if (state == null) {
                toRemove.add(entry);
                changed = true;
                continue;
            }
            entry.setState(state);
            if (this.isInGroup(state, group)) continue;
            toRemove.add(entry);
            changed = true;
        }
        for (GroupEntry entry : toRemove) {
            this.removeEntry((AbstractSelectionList.Entry)entry);
        }
        for (PlayerState state : playerStates) {
            if (!this.isInGroup(state, group) || !this.children().stream().noneMatch(groupEntry -> groupEntry.getState().getUuid().equals(state.getUuid()))) continue;
            this.addEntry((AbstractSelectionList.Entry)new GroupEntry(this.parent, state));
            changed = true;
        }
        if (changed) {
            this.sort(Comparator.comparing(o -> o.getState().getName()));
        }
    }

    public static void update() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof GroupScreen) {
            GroupScreen groupScreen = (GroupScreen)screen;
            groupScreen.groupList.updateMembers();
        }
    }

    private boolean isInGroup(PlayerState state, UUID group) {
        return state.hasGroup() && state.getGroup().equals(group);
    }
}

