/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.onboarding;

import de.maxhenkel.voicechat.gui.onboarding.FinalOnboardingScreen;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingScreenBase;
import de.maxhenkel.voicechat.gui.widgets.KeybindButton;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class PttOnboardingScreen
extends OnboardingScreenBase {
    private static final Component TITLE = Component.translatable((String)"message.voicechat.onboarding.ptt.title").withStyle(ChatFormatting.BOLD);
    private static final Component DESCRIPTION = Component.translatable((String)"message.voicechat.onboarding.ptt.description");
    private static final Component BUTTON_DESCRIPTION = Component.translatable((String)"message.voicechat.onboarding.ptt.button_description");
    protected KeybindButton keybindButton;
    protected int keybindButtonPos;

    public PttOnboardingScreen(@Nullable Screen previous) {
        super(TITLE, previous);
    }

    @Override
    protected void init() {
        super.init();
        this.keybindButtonPos = this.guiTop + this.contentHeight - 60 - 16 - 40;
        this.keybindButton = new KeybindButton(KeyEvents.KEY_PTT, this.guiLeft + 40, this.keybindButtonPos, this.contentWidth - 80, 20);
        this.addRenderableWidget((GuiEventListener)this.keybindButton);
        this.addBackOrCancelButton();
        this.addNextButton();
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (this.keybindButton.mouseClicked(mouseButtonEvent, bl)) {
            return true;
        }
        return super.mouseClicked(mouseButtonEvent, bl);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.keybindButton.keyPressed(keyEvent)) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        if (this.keybindButton.keyReleased(keyEvent)) {
            return true;
        }
        return super.keyReleased(keyEvent);
    }

    @Override
    public Screen getNextScreen() {
        return new FinalOnboardingScreen(this);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTitle(guiGraphics, TITLE);
        this.renderMultilineText(guiGraphics, DESCRIPTION);
        FormattedCharSequence formattedCharSequence = BUTTON_DESCRIPTION.getVisualOrderText();
        int n = this.width / 2 - this.font.width((FormattedText)BUTTON_DESCRIPTION) / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, formattedCharSequence, n, this.keybindButtonPos - 9 - 8, -1, true);
    }

    public boolean shouldCloseOnEsc() {
        if (this.keybindButton.isListening()) {
            return false;
        }
        return super.shouldCloseOnEsc();
    }
}

