/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.ForgeNetManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.permission.ForgePermissionManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;

public class ForgeCommonCompatibilityManager
extends CommonCompatibilityManager {
    private final List<Consumer<MinecraftServer>> serverStartingEvents = new CopyOnWriteArrayList<Consumer<MinecraftServer>>();
    private final List<Consumer<MinecraftServer>> serverStoppingEvents = new CopyOnWriteArrayList<Consumer<MinecraftServer>>();
    private final List<Consumer<CommandDispatcher<CommandSourceStack>>> registerServerCommandsEvents = new CopyOnWriteArrayList<Consumer<CommandDispatcher<CommandSourceStack>>>();
    private final List<Consumer<ServerPlayer>> playerLoggedInEvents = new CopyOnWriteArrayList<Consumer<ServerPlayer>>();
    private final List<Consumer<ServerPlayer>> playerLoggedOutEvents = new CopyOnWriteArrayList<Consumer<ServerPlayer>>();
    private final List<Consumer<ServerPlayer>> voicechatConnectEvents = new CopyOnWriteArrayList<Consumer<ServerPlayer>>();
    private final List<Consumer<ServerPlayer>> voicechatCompatibilityCheckSucceededEvents = new CopyOnWriteArrayList<Consumer<ServerPlayer>>();
    private final List<Consumer<UUID>> voicechatDisconnectEvents = new CopyOnWriteArrayList<Consumer<UUID>>();
    private ForgeNetManager netManager;

    public void serverStarting(ServerStartedEvent event) {
        this.serverStartingEvents.forEach(consumer -> consumer.accept(event.getServer()));
    }

    public void serverStopping(ServerStoppingEvent event) {
        this.serverStoppingEvents.forEach(consumer -> consumer.accept(event.getServer()));
    }

    public void onRegisterCommands(RegisterCommandsEvent event) {
        this.registerServerCommandsEvents.forEach(consumer -> consumer.accept(event.getDispatcher()));
    }

    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.playerLoggedInEvents.forEach(consumer -> consumer.accept(player2));
        }
    }

    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.playerLoggedOutEvents.forEach(consumer -> consumer.accept(player2));
        }
    }

    @Override
    public String getModVersion() {
        return ModList.get().getModFileById("voicechat").versionString();
    }

    @Override
    public String getModName() {
        return ModList.get().getMods().stream().filter(info -> info.getModId().equals("voicechat")).findAny().map(IModInfo::getDisplayName).orElse("voicechat");
    }

    @Override
    public Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public void emitServerVoiceChatConnectedEvent(ServerPlayer player) {
        this.voicechatConnectEvents.forEach(consumer -> consumer.accept(player));
    }

    @Override
    public void emitServerVoiceChatDisconnectedEvent(UUID clientID) {
        this.voicechatDisconnectEvents.forEach(consumer -> consumer.accept(clientID));
    }

    @Override
    public void emitPlayerCompatibilityCheckSucceeded(ServerPlayer player) {
        this.voicechatCompatibilityCheckSucceededEvents.forEach(consumer -> consumer.accept(player));
    }

    @Override
    public void onServerVoiceChatConnected(Consumer<ServerPlayer> onVoiceChatConnected) {
        this.voicechatConnectEvents.add(onVoiceChatConnected);
    }

    @Override
    public void onServerVoiceChatDisconnected(Consumer<UUID> onVoiceChatDisconnected) {
        this.voicechatDisconnectEvents.add(onVoiceChatDisconnected);
    }

    @Override
    public void onServerStarting(Consumer<MinecraftServer> onServerStarting) {
        this.serverStartingEvents.add(onServerStarting);
    }

    @Override
    public void onServerStopping(Consumer<MinecraftServer> onServerStopping) {
        this.serverStoppingEvents.add(onServerStopping);
    }

    @Override
    public void onPlayerLoggedIn(Consumer<ServerPlayer> onPlayerLoggedIn) {
        this.playerLoggedInEvents.add(onPlayerLoggedIn);
    }

    @Override
    public void onPlayerLoggedOut(Consumer<ServerPlayer> onPlayerLoggedOut) {
        this.playerLoggedOutEvents.add(onPlayerLoggedOut);
    }

    @Override
    public void onPlayerHide(BiConsumer<ServerPlayer, ServerPlayer> onPlayerHide) {
    }

    @Override
    public void onPlayerShow(BiConsumer<ServerPlayer, ServerPlayer> onPlayerShow) {
    }

    @Override
    public void onPlayerCompatibilityCheckSucceeded(Consumer<ServerPlayer> onPlayerCompatibilityCheckSucceeded) {
        this.voicechatCompatibilityCheckSucceededEvents.add(onPlayerCompatibilityCheckSucceeded);
    }

    @Override
    public void onRegisterServerCommands(Consumer<CommandDispatcher<CommandSourceStack>> onRegisterServerCommands) {
        this.registerServerCommandsEvents.add(onRegisterServerCommands);
    }

    @Override
    public NetManager getNetManager() {
        if (this.netManager == null) {
            this.netManager = new ForgeNetManager();
        }
        return this.netManager;
    }

    @Override
    public boolean isDevEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist().isDedicatedServer();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public List<VoicechatPlugin> loadPlugins() {
        ArrayList<VoicechatPlugin> plugins = new ArrayList<VoicechatPlugin>();
        ModList.get().getAllScanData().forEach(scan -> scan.getAnnotations().forEach(annotationData -> {
            if (annotationData.annotationType().getClassName().equals(ForgeVoicechatPlugin.class.getName())) {
                try {
                    Class<?> clazz = Class.forName(annotationData.memberName());
                    if (VoicechatPlugin.class.isAssignableFrom(clazz)) {
                        VoicechatPlugin plugin = (VoicechatPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        plugins.add(plugin);
                    }
                }
                catch (Throwable e) {
                    Voicechat.LOGGER.warn("Failed to load plugin '{}'", annotationData.memberName(), e);
                }
            }
        }));
        return plugins;
    }

    @Override
    public PermissionManager createPermissionManager() {
        return new ForgePermissionManager();
    }

    @Override
    public boolean canSee(ServerPlayer player, ServerPlayer other) {
        return true;
    }
}

