/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonInfo;

public class PTTKeyHandler {
    private boolean pttKeyDown;
    private boolean whisperKeyDown;

    public PTTKeyHandler() {
        ClientCompatibilityManager.INSTANCE.onKeyboardEvent(this::onKeyboardEvent);
        ClientCompatibilityManager.INSTANCE.onMouseEvent(this::onMouseEvent);
    }

    public void onKeyboardEvent(KeyEvent keyEvent) {
        InputConstants.Key whisperKey;
        InputConstants.Key pttKey = ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_PTT);
        if (pttKey.getValue() != -1 && !pttKey.getType().equals((Object)InputConstants.Type.MOUSE)) {
            this.pttKeyDown = InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)pttKey.getValue());
        }
        if ((whisperKey = ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_WHISPER)).getValue() != -1 && !whisperKey.getType().equals((Object)InputConstants.Type.MOUSE)) {
            this.whisperKeyDown = InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)whisperKey.getValue());
        }
    }

    public void onMouseEvent(MouseButtonInfo mouseButtonInfo, int action) {
        InputConstants.Key whisperKey;
        InputConstants.Key pttKey = ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_PTT);
        if (pttKey.getValue() != -1 && pttKey.getType().equals((Object)InputConstants.Type.MOUSE) && pttKey.getValue() == mouseButtonInfo.button()) {
            boolean bl = this.pttKeyDown = action != 0;
        }
        if ((whisperKey = ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_WHISPER)).getValue() != -1 && whisperKey.getType().equals((Object)InputConstants.Type.MOUSE) && whisperKey.getValue() == mouseButtonInfo.button()) {
            this.whisperKeyDown = action != 0;
        }
    }

    public boolean isPTTDown() {
        return this.pttKeyDown;
    }

    public boolean isWhisperDown() {
        return this.whisperKeyDown;
    }

    public boolean isAnyDown() {
        return this.pttKeyDown || this.whisperKeyDown;
    }
}

