/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceList;
import de.maxhenkel.voicechat.gui.audiodevice.MicrophoneAudioDeviceEntry;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.voice.client.microphone.MicrophoneManager;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class MicrophoneAudioDeviceList
extends AudioDeviceList {
    public static final Identifier MICROPHONE_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone.png");
    public static final Component DEFAULT_MICROPHONE = Component.translatable((String)"message.voicechat.default_microphone");
    private final MicTestButton micTestButton;

    public MicrophoneAudioDeviceList(Screen screen, int width, int height, int top) {
        super(width, height, top);
        this.defaultDeviceText = DEFAULT_MICROPHONE;
        this.icon = MICROPHONE_ICON;
        this.configEntry = VoicechatClient.CLIENT_CONFIG.microphone;
        this.micTestButton = new MicTestButton(0, 0, true);
        screen.children().add(this.micTestButton);
        this.setAudioDevices(MicrophoneManager.deviceNames());
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderWidget(guiGraphics, i, j, f);
        this.micTestButton.updateLastRender();
    }

    @Override
    public AudioDeviceEntry createAudioDeviceEntry(String device, Component name, @Nullable Identifier icon, Supplier<Boolean> isSelected) {
        return new MicrophoneAudioDeviceEntry(device, name, icon, isSelected, this.micTestButton);
    }
}

