/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class KeybindButton
extends AbstractButton {
    private static final Minecraft mc = Minecraft.getInstance();
    protected KeyMapping keyMapping;
    @Nullable
    protected Component description;
    protected boolean listening;

    public KeybindButton(KeyMapping mapping, int x, int y, int width, int height, @Nullable Component description) {
        super(x, y, width, height, (Component)Component.empty());
        this.keyMapping = mapping;
        this.description = description;
        this.updateText();
    }

    public KeybindButton(KeyMapping mapping, int x, int y, int width, int height) {
        this(mapping, x, y, width, height, null);
    }

    protected void updateText() {
        MutableComponent text = this.listening ? Component.literal((String)"> ").append((Component)KeybindButton.getText(this.keyMapping).copy().withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE})).append(" <").withStyle(ChatFormatting.YELLOW) : KeybindButton.getText(this.keyMapping).copy();
        if (this.description != null) {
            text = this.description.copy().append(": ").append((Component)text);
        }
        this.setMessage((Component)text);
    }

    private static Component getText(KeyMapping keyMapping) {
        return keyMapping.getTranslatedKeyMessage();
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.listening = true;
        this.updateText();
    }

    protected void renderContents(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderDefaultSprite(guiGraphics);
        this.renderDefaultLabel(guiGraphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE));
    }

    public boolean mouseClicked(MouseButtonEvent evt, boolean bl) {
        if (this.listening) {
            if (evt.button() == 0) {
                this.listening = false;
                this.updateText();
                return this.isMouseOver(evt.x(), evt.y());
            }
            this.keyMapping.setKey(InputConstants.Type.MOUSE.getOrCreate(evt.button()));
            KeybindButton.mc.options.save();
            this.listening = false;
            this.updateText();
            return true;
        }
        return super.mouseClicked(evt, bl);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.listening) {
            if (keyEvent.isEscape()) {
                this.keyMapping.setKey(InputConstants.UNKNOWN);
            } else {
                this.keyMapping.setKey(InputConstants.getKey((KeyEvent)keyEvent));
            }
            KeybindButton.mc.options.save();
            this.listening = false;
            this.updateText();
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        if (this.listening && keyEvent.isEscape()) {
            return true;
        }
        return super.keyReleased(keyEvent);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean isListening() {
        return this.listening;
    }

    public void resetListening() {
        this.listening = false;
        this.updateText();
    }
}

