/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.natives;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.natives.Denoiser;
import de.maxhenkel.voicechat.natives.NativeUtils;
import de.maxhenkel.voicechat.natives.NativeValidator;
import javax.annotation.Nullable;

public class RNNoiseManager
extends NativeValidator {
    private static RNNoiseManager instance;

    @Override
    protected void runValidation() throws Throwable {
        try (Denoiser denoiser = new Denoiser();){
            denoiser.denoiseInPlace(new short[denoiser.getFrameSize()]);
            denoiser.denoise(new short[denoiser.getFrameSize()]);
        }
    }

    @Override
    protected String getNativeName() {
        return "RNNoise";
    }

    @Nullable
    public static Denoiser createDenoiser() {
        RNNoiseManager instance = RNNoiseManager.instance();
        if (!instance.canUse()) {
            return null;
        }
        return NativeUtils.createSafe(Denoiser::new, e -> {
            instance.setFailed(e.getMessage());
            Voicechat.LOGGER.warn("Failed to load RNNoise", e);
        });
    }

    public static boolean canUseDenoiser() {
        return RNNoiseManager.instance().canUse();
    }

    public static void init() {
        RNNoiseManager.instance().initialize();
    }

    public static boolean isFailed() {
        return !RNNoiseManager.instance().canUse();
    }

    public static String getFailedMessage() {
        return RNNoiseManager.instance().getMessage();
    }

    private static synchronized RNNoiseManager instance() {
        if (instance == null) {
            instance = new RNNoiseManager();
        }
        return instance;
    }
}

