/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.natives.RNNoiseManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class VoiceActivationSlider
extends DebouncedSlider
implements MicTestButton.MicListener {
    private static final class_2960 SLIDER = new class_2960("voicechat", "textures/gui/voice_activation_slider.png");
    private static final class_2561 NO_ACTIVATION = class_2561.method_43471((String)"message.voicechat.voice_activation.disabled").method_27692(class_124.field_1061);
    private final SlidingMaxSmooth micValue;

    public VoiceActivationSlider(int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), AudioUtils.dbToPerc(VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get().floatValue()));
        this.method_25346();
        this.micValue = new SlidingMaxSmooth();
    }

    public boolean shouldShowSlider() {
        if (!MicrophoneActivationType.VOICE.equals((Object)VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get())) {
            return false;
        }
        if (!RNNoiseManager.canUseDenoiser()) {
            return true;
        }
        return VoicechatClient.CLIENT_CONFIG.vad.get() == false;
    }

    protected void method_25353(class_4587 poseStack, class_310 minecraft, int i, int j) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SLIDER);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = (int)((double)(this.method_25368() - 2) * this.micValue.smoothMax());
        this.method_25302(poseStack, this.field_22760 + 1, this.field_22761 + 1, 0, 0, width, 18);
        boolean shouldShow = this.shouldShowSlider();
        if (shouldShow != this.field_22763) {
            this.field_22763 = shouldShow;
            this.method_25346();
        }
        if (!this.field_22763) {
            return;
        }
        super.method_25353(poseStack, minecraft, i, j);
    }

    protected void method_25346() {
        if (!this.field_22763) {
            this.method_25355((class_2561)class_2561.method_43473());
            return;
        }
        long db = Math.round(AudioUtils.percToDb(this.field_22753));
        class_5250 component = class_2561.method_43469((String)"message.voicechat.voice_activation", (Object[])new Object[]{db});
        if (db >= -10L) {
            component.method_27692(class_124.field_1061);
        }
        this.method_25355((class_2561)component);
    }

    @Nullable
    public class_2561 getHoverText() {
        if (!this.field_22763) {
            return null;
        }
        if (this.field_22753 >= 1.0) {
            return NO_ACTIVATION;
        }
        return null;
    }

    public boolean isHovered() {
        return this.field_22762;
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.set(AudioUtils.percToDb(this.field_22753)).save();
    }

    @Override
    public void onMicValue(double dB) {
        this.micValue.add(AudioUtils.dbToPerc(dB));
    }

    @Override
    public void onStop() {
        this.micValue.reset();
    }

    private static class SlidingMaxSmooth {
        private final double[] values = new double[15];
        private int n;
        private int p;
        private static final double SMOOTHING_PER_SEC = 25.0;
        private double smoothed;
        private long lastNs = -1L;

        private SlidingMaxSmooth() {
        }

        public void add(double x) {
            if (this.n < this.values.length) {
                ++this.n;
            }
            this.values[this.p] = x;
            this.p = (this.p + 1) % this.values.length;
        }

        public double max() {
            if (this.n == 0) {
                return 0.0;
            }
            int len = Math.min(this.n, this.values.length);
            double max = this.values[0];
            for (int i = 1; i < len; ++i) {
                if (!(this.values[i] > max)) continue;
                max = this.values[i];
            }
            return max;
        }

        public double smoothMax() {
            long nowNanos = System.nanoTime();
            double target = this.max();
            if (this.lastNs < 0L) {
                this.lastNs = nowNanos;
                this.smoothed = target;
                return this.smoothed;
            }
            double dt = (double)(nowNanos - this.lastNs) / 1.0E9;
            this.lastNs = nowNanos;
            double alpha = dt * 25.0;
            if (alpha > 1.0) {
                alpha = 1.0;
            }
            if (alpha < 0.0) {
                alpha = 0.0;
            }
            this.smoothed += (target - this.smoothed) * alpha;
            return this.smoothed;
        }

        public void reset() {
            this.n = 0;
            this.p = 0;
            this.smoothed = 0.0;
            this.lastNs = -1L;
        }
    }
}

