/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.debug.DebugOverlay;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.macos.PermissionCheck;
import de.maxhenkel.voicechat.macos.VersionCheck;
import de.maxhenkel.voicechat.macos.avfoundation.AVAuthorizationStatus;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.voice.client.ChatUtils;
import de.maxhenkel.voicechat.voice.client.ClientCategoryManager;
import de.maxhenkel.voicechat.voice.client.ClientGroupManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.InitializationData;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.PTTKeyHandler;
import de.maxhenkel.voicechat.voice.client.RenderEvents;
import de.maxhenkel.voicechat.voice.server.Server;
import io.netty.channel.local.LocalAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class ClientManager {
    @Nullable
    private ClientVoicechat client;
    private final ClientPlayerStateManager playerStateManager = new ClientPlayerStateManager();
    private final ClientGroupManager groupManager = new ClientGroupManager();
    private final ClientCategoryManager categoryManager = new ClientCategoryManager();
    private final PTTKeyHandler pttKeyHandler = new PTTKeyHandler();
    private final RenderEvents renderEvents = new RenderEvents();
    private final DebugOverlay debugOverlay = new DebugOverlay();
    private final KeyEvents keyEvents = new KeyEvents();
    private final class_310 minecraft = class_310.method_1551();
    private boolean hasShownPermissionsMessage;
    private static ClientManager instance;

    private ClientManager() {
        ClientCompatibilityManager.INSTANCE.onJoinWorld(this::onJoinWorld);
        ClientCompatibilityManager.INSTANCE.onDisconnect(this::onDisconnect);
        ClientCompatibilityManager.INSTANCE.onPublishServer(this::onPublishServer);
        ClientCompatibilityManager.INSTANCE.onVoiceChatConnected(connection -> {
            if (this.client != null) {
                this.client.onVoiceChatConnected((ClientVoicechatConnection)connection);
            }
        });
        ClientCompatibilityManager.INSTANCE.onVoiceChatDisconnected(() -> {
            if (this.client != null) {
                this.client.onVoiceChatDisconnected();
            }
        });
        ClientServerNetManager.setClientListener(CommonCompatibilityManager.INSTANCE.getNetManager().secretChannel, (client, handler, packet) -> this.authenticate((SecretPacket)packet));
    }

    private void authenticate(SecretPacket secretPacket) {
        class_634 connection;
        if (this.client == null) {
            Voicechat.LOGGER.error("Received secret without a client being present", new Object[0]);
            return;
        }
        Voicechat.LOGGER.info("Received secret", new Object[0]);
        if (this.client.getConnection() != null) {
            ClientCompatibilityManager.INSTANCE.emitVoiceChatDisconnectedEvent();
        }
        if ((connection = this.minecraft.method_1562()) != null) {
            try {
                SocketAddress socketAddress = ClientCompatibilityManager.INSTANCE.getSocketAddress(connection.method_2872());
                this.client.connect(new InitializationData(ClientManager.resolveAddress(socketAddress), secretPacket));
            }
            catch (Exception e) {
                Voicechat.LOGGER.error("Failed to connect to voice chat server", e);
            }
        }
    }

    private static String resolveAddress(SocketAddress socketAddress) throws IOException {
        if (socketAddress instanceof LocalAddress) {
            return "127.0.0.1";
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IOException(String.format("Failed to determine server address with SocketAddress of type %s", socketAddress.getClass().getSimpleName()));
        }
        InetSocketAddress address = (InetSocketAddress)socketAddress;
        InetAddress inetAddress = address.getAddress();
        if (inetAddress == null) {
            return address.getHostString();
        }
        return inetAddress.getHostAddress();
    }

    private void onJoinWorld() {
        if (VoicechatClient.CLIENT_CONFIG.muteOnJoin.get().booleanValue()) {
            this.playerStateManager.setMuted(true);
        }
        if (this.client != null) {
            Voicechat.LOGGER.info("Disconnecting from previous connection due to server change", new Object[0]);
            ClientCompatibilityManager.INSTANCE.emitDisconnectedEvent();
        }
        this.hasShownPermissionsMessage = false;
        Voicechat.LOGGER.info("Sending secret request to the server", new Object[0]);
        ClientServerNetManager.sendToServer(new RequestSecretPacket(Voicechat.COMPATIBILITY_VERSION));
        this.client = new ClientVoicechat();
    }

    public void checkMicrophonePermissions() {
        if (!VoicechatClient.CLIENT_CONFIG.macosCheckMicrophonePermission.get().booleanValue()) {
            return;
        }
        if (VersionCheck.isMacOSNativeCompatible()) {
            AVAuthorizationStatus status = PermissionCheck.getMicrophonePermissions();
            if (status.equals((Object)AVAuthorizationStatus.DENIED)) {
                if (!this.hasShownPermissionsMessage) {
                    ChatUtils.sendModErrorMessage("message.voicechat.macos_no_mic_permission");
                    this.hasShownPermissionsMessage = true;
                }
                Voicechat.LOGGER.warn("User hasn't granted microphone permissions: {}", status.name());
            } else if (!status.equals((Object)AVAuthorizationStatus.AUTHORIZED)) {
                if (!this.hasShownPermissionsMessage) {
                    ChatUtils.sendModErrorMessage("message.voicechat.macos_unsupported_launcher");
                    this.hasShownPermissionsMessage = true;
                }
                Voicechat.LOGGER.warn("User has an unsupported launcher: {}", status.name());
            }
        }
    }

    private void onDisconnect() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        ClientCompatibilityManager.INSTANCE.emitVoiceChatDisconnectedEvent();
    }

    private void onPublishServer(int port) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return;
        }
        try {
            ClientVoicechatConnection connection;
            Voicechat.LOGGER.info("Changing voice chat port to {}", port);
            server.changePort(port);
            ClientVoicechat client = ClientManager.getClient();
            if (client != null && (connection = client.getConnection()) != null) {
                Voicechat.LOGGER.info("Force disconnecting due to port change", new Object[0]);
                connection.disconnect();
            }
            ClientServerNetManager.sendToServer(new RequestSecretPacket(Voicechat.COMPATIBILITY_VERSION));
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to change voice chat port", e);
        }
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"message.voicechat.server_port", (Object[])new Object[]{server.getPort()}));
    }

    @Nullable
    public static ClientVoicechat getClient() {
        return ClientManager.instance().client;
    }

    public static ClientPlayerStateManager getPlayerStateManager() {
        return ClientManager.instance().playerStateManager;
    }

    public static ClientGroupManager getGroupManager() {
        return ClientManager.instance().groupManager;
    }

    public static ClientCategoryManager getCategoryManager() {
        return ClientManager.instance().categoryManager;
    }

    public static PTTKeyHandler getPttKeyHandler() {
        return ClientManager.instance().pttKeyHandler;
    }

    public static RenderEvents getRenderEvents() {
        return ClientManager.instance().renderEvents;
    }

    public static DebugOverlay getDebugOverlay() {
        return ClientManager.instance().debugOverlay;
    }

    public KeyEvents getKeyEvents() {
        return this.keyEvents;
    }

    public static synchronized ClientManager instance() {
        if (instance == null) {
            instance = new ClientManager();
        }
        return instance;
    }
}

