/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public abstract class DebouncedSlider
extends AbstractSliderButton {
    private boolean dragged;
    private double lastValue;

    public DebouncedSlider(int i, int j, int k, int l, Component component, double d) {
        super(i, j, k, l, component, d);
        this.lastValue = d;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        boolean result = super.keyPressed(keyEvent);
        if (keyEvent.isLeft() || keyEvent.isRight()) {
            this.applyDebouncedInternal();
        }
        return result;
    }

    public void onClick(MouseButtonEvent mouseButtonEvent, boolean bl) {
        super.onClick(mouseButtonEvent, bl);
        this.applyDebouncedInternal();
    }

    protected void onDrag(MouseButtonEvent mouseButtonEvent, double d, double e) {
        super.onDrag(mouseButtonEvent, d, e);
        this.dragged = true;
        if (this.value >= 1.0 || this.value <= 0.0) {
            this.applyDebouncedInternal();
            this.dragged = false;
        }
    }

    public void onRelease(MouseButtonEvent mouseButtonEvent) {
        super.onRelease(mouseButtonEvent);
        if (this.dragged) {
            this.applyDebouncedInternal();
            this.dragged = false;
        }
    }

    private void applyDebouncedInternal() {
        if (this.value == this.lastValue) {
            return;
        }
        this.lastValue = this.value;
        this.applyDebounced();
    }

    public abstract void applyDebounced();

    protected void applyValue() {
    }
}

