/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.Channel;
import de.maxhenkel.voicechat.net.ClientServerChannel;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.EventNetworkChannel;
import net.minecraftforge.network.PacketDistributor;

public class ForgeNetManager
extends NetManager {
    private final Map<Identifier, net.minecraftforge.network.Channel<FriendlyByteBuf>> channels = new HashMap<Identifier, net.minecraftforge.network.Channel<FriendlyByteBuf>>();

    @Override
    public <T extends Packet<T>> Channel<T> registerReceiver(Class<T> packetType, boolean toClient, boolean toServer) {
        ClientServerChannel c = new ClientServerChannel();
        try {
            Packet dummyPacket = (Packet)packetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            EventNetworkChannel channel = ChannelBuilder.named((Identifier)dummyPacket.type().id()).acceptedVersions((status, version) -> true).optional().networkProtocolVersion(Voicechat.COMPATIBILITY_VERSION).eventNetworkChannel();
            channel.addListener(event -> {
                if (event.getPayload() == null) {
                    return;
                }
                CustomPayloadEvent.Context context = event.getSource();
                if (toServer && context.isServerSide()) {
                    try {
                        if (!Voicechat.SERVER.isCompatible(context.getSender()) && !packetType.equals(RequestSecretPacket.class)) {
                            return;
                        }
                        Packet packet = (Packet)packetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        packet.fromBytes(event.getPayload());
                        c.onServerPacket(context.getSender(), packet);
                        context.setPacketHandled(true);
                    }
                    catch (Exception e) {
                        Voicechat.LOGGER.error("Failed to process packet", e);
                    }
                } else {
                    if (this.isSameThread()) {
                        return;
                    }
                    try {
                        Packet packet = (Packet)packetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        packet.fromBytes(event.getPayload());
                        this.onClientPacket(c, packet);
                        context.setPacketHandled(true);
                    }
                    catch (Exception e) {
                        Voicechat.LOGGER.error("Failed to process packet", e);
                    }
                }
            });
            this.channels.put(dummyPacket.type().id(), (net.minecraftforge.network.Channel<FriendlyByteBuf>)channel);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return c;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void sendToServerInternal(Packet<?> packet) {
        net.minecraftforge.network.Channel<FriendlyByteBuf> channel = this.channels.get(packet.type().id());
        if (channel == null) {
            throw new IllegalArgumentException("No channel for packet %s".formatted(packet.type().id()));
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        packet.toBytes(buffer);
        channel.send((Object)buffer, PacketDistributor.SERVER.noArg());
    }

    @Override
    public void sendToClient(Packet<?> packet, ServerPlayer player) {
        net.minecraftforge.network.Channel<FriendlyByteBuf> channel = this.channels.get(packet.type().id());
        if (channel == null) {
            throw new IllegalArgumentException("No channel for packet %s".formatted(packet.type().id()));
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        packet.toBytes(buffer);
        channel.send((Object)buffer, PacketDistributor.PLAYER.with((Object)player));
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T extends Packet<T>> void onClientPacket(ClientServerChannel<T> channel, T packet) {
        channel.onClientPacket(Minecraft.getInstance().player, packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isSameThread() {
        return Minecraft.getInstance().isSameThread();
    }
}

