/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.PlayerSkin;

public class GroupChatManager {
    private static final Identifier TALK_OUTLINE = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/talk_outline.png");
    private static final Identifier SPEAKER_OFF_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker_small_off.png");

    public static void renderIcons(GuiGraphics guiGraphics) {
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        List<PlayerState> groupMembers = GroupChatManager.getGroupMembers(VoicechatClient.CLIENT_CONFIG.showOwnGroupIcon.get());
        guiGraphics.pose().pushMatrix();
        int posX = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosY.get();
        if (posX < 0) {
            guiGraphics.pose().translate((float)mc.getWindow().getGuiScaledWidth(), 0.0f);
        }
        if (posY < 0) {
            guiGraphics.pose().translate(0.0f, (float)mc.getWindow().getGuiScaledHeight());
        }
        guiGraphics.pose().translate((float)posX, (float)posY);
        float scale = VoicechatClient.CLIENT_CONFIG.groupHudIconScale.get().floatValue();
        guiGraphics.pose().scale(scale, scale);
        boolean vertical = VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.get().equals((Object)GroupPlayerIconOrientation.VERTICAL);
        for (int i = 0; i < groupMembers.size(); ++i) {
            PlayerState state = groupMembers.get(i);
            guiGraphics.pose().pushMatrix();
            if (vertical) {
                if (posY < 0) {
                    guiGraphics.pose().translate(0.0f, (float)i * -11.0f);
                } else {
                    guiGraphics.pose().translate(0.0f, (float)i * 11.0f);
                }
            } else if (posX < 0) {
                guiGraphics.pose().translate((float)i * -11.0f, 0.0f);
            } else {
                guiGraphics.pose().translate((float)i * 11.0f, 0.0f);
            }
            if (client.getTalkCache().isTalking(state.getUuid())) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TALK_OUTLINE, posX < 0 ? -10 : 0, posY < 0 ? -10 : 0, 0.0f, 0.0f, 10, 10, 16, 16);
            }
            PlayerSkin skin = GameProfileUtils.getSkin(state.getUuid());
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skin.body().texturePath(), posX < 0 ? -9 : 1, posY < 0 ? -9 : 1, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skin.body().texturePath(), posX < 0 ? -9 : 1, posY < 0 ? -9 : 1, 40.0f, 8.0f, 8, 8, 64, 64);
            if (state.isDisabled()) {
                guiGraphics.pose().pushMatrix();
                guiGraphics.pose().translate(posX < 0 ? -9.0f : 1.0f, posY < 0 ? -9.0f : 1.0f);
                guiGraphics.pose().scale(0.5f, 0.5f);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, SPEAKER_OFF_ICON, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.pose().popMatrix();
            }
            guiGraphics.pose().popMatrix();
        }
        guiGraphics.pose().popMatrix();
    }

    public static List<PlayerState> getGroupMembers() {
        return GroupChatManager.getGroupMembers(true);
    }

    public static List<PlayerState> getGroupMembers(boolean includeSelf) {
        ArrayList<PlayerState> entries = new ArrayList<PlayerState>();
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            return entries;
        }
        for (PlayerState state : ClientManager.getPlayerStateManager().getPlayerStates(includeSelf)) {
            if (!state.hasGroup() || !state.getGroup().equals(group)) continue;
            entries.add(state);
        }
        entries.sort(Comparator.comparing(PlayerState::getName));
        return entries;
    }
}

