/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.commodore.file;

import com.mojang.brigadier.tree.LiteralCommandNode;
import de.maxhenkel.voicechat.commodore.file.ArgumentTypeParser;
import de.maxhenkel.voicechat.commodore.file.BrigadierArgumentTypeParser;
import de.maxhenkel.voicechat.commodore.file.Lexer;
import de.maxhenkel.voicechat.commodore.file.ParseException;
import de.maxhenkel.voicechat.commodore.file.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CommodoreFileReader {
    public static final CommodoreFileReader INSTANCE = CommodoreFileReader.builder().withArgumentTypeParser(BrigadierArgumentTypeParser.INSTANCE).build();
    private final List<ArgumentTypeParser> argumentTypeParsers;

    public static Builder builder() {
        return new Builder();
    }

    CommodoreFileReader(List<ArgumentTypeParser> argumentTypeParsers) {
        this.argumentTypeParsers = Collections.unmodifiableList(argumentTypeParsers);
    }

    public <S> LiteralCommandNode<S> parse(Reader reader) throws IOException {
        try {
            return new Parser(new Lexer(reader), this.argumentTypeParsers).parse();
        }
        catch (ParseException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public <S> LiteralCommandNode<S> parse(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            LiteralCommandNode<S> literalCommandNode = this.parse(reader);
            return literalCommandNode;
        }
    }

    public <S> LiteralCommandNode<S> parse(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            LiteralCommandNode<S> literalCommandNode = this.parse(reader);
            return literalCommandNode;
        }
    }

    public <S> LiteralCommandNode<S> parse(File file) throws IOException {
        return this.parse(file.toPath());
    }

    public static final class Builder {
        private final List<ArgumentTypeParser> argumentTypeParsers = new ArrayList<ArgumentTypeParser>();

        Builder() {
        }

        public Builder withArgumentTypeParser(ArgumentTypeParser argumentTypeParser) {
            Objects.requireNonNull(argumentTypeParser, "argumentTypeParser");
            this.argumentTypeParsers.add(argumentTypeParser);
            return this;
        }

        public CommodoreFileReader build() {
            return new CommodoreFileReader(new ArrayList<ArgumentTypeParser>(this.argumentTypeParsers));
        }
    }
}

