/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.compatibility;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.compatibility.Compatibility;
import de.maxhenkel.voicechat.compatibility.ReflectionUtils;
import de.maxhenkel.voicechat.util.Key;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class BaseCompatibility
implements Compatibility {
    private String baseBukkitPackage;
    private String baseServerPackage;
    private Method addChannel;
    private Method removeChannel;
    private Consumer<Runnable> runTask;
    private TaskScheduler taskScheduler;

    @Override
    public void init() throws Exception {
        Compatibility.super.init();
        this.baseBukkitPackage = Bukkit.getServer().getClass().getPackage().getName();
        this.baseServerPackage = ReflectionUtils.callMethod((Object)Bukkit.getServer(), "getServer").getClass().getPackage().getName();
        Class<?> craftPlayer = this.getBukkitClass("entity.CraftPlayer");
        this.addChannel = ReflectionUtils.getMethod(craftPlayer, new String[]{"addChannel"}, new Class[]{String.class});
        this.removeChannel = ReflectionUtils.getMethod(craftPlayer, new String[]{"removeChannel"}, new Class[]{String.class});
        this.runTask = runnable -> Bukkit.getScheduler().runTask((Plugin)Voicechat.INSTANCE, runnable);
        this.taskScheduler = (runnable, delay, period) -> Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Voicechat.INSTANCE, runnable, delay, period);
        if (ReflectionUtils.doesMethodExist(Bukkit.class, "getGlobalRegionScheduler", new Class[0])) {
            Object globalRegionScheduler = ReflectionUtils.callMethod(Bukkit.class, "getGlobalRegionScheduler");
            Method run = ReflectionUtils.getMethod(globalRegionScheduler.getClass(), new String[]{"run"}, new Class[]{Plugin.class, Consumer.class});
            this.runTask = runnable -> ReflectionUtils.call(run, globalRegionScheduler, new Object[]{Voicechat.INSTANCE, task -> runnable.run()});
            if (ReflectionUtils.doesMethodExist(globalRegionScheduler.getClass(), "runAtFixedRate", new Class[0])) {
                Method runAtFixedRate = ReflectionUtils.getMethod(globalRegionScheduler.getClass(), new String[]{"runAtFixedRate"}, new Class[]{Plugin.class, Consumer.class, Long.class, Long.class});
                this.taskScheduler = (runnable, delay, period) -> ReflectionUtils.call(runAtFixedRate, globalRegionScheduler, new Object[]{Voicechat.INSTANCE, task -> runnable.run(), delay, period});
            }
        }
    }

    @Override
    public void addChannel(Player player, String channel) {
        ReflectionUtils.call(this.addChannel, player, channel);
    }

    @Override
    public void removeChannel(Player player, String channel) {
        ReflectionUtils.call(this.removeChannel, player, channel);
    }

    @Override
    public Key createNamespacedKey(String key) {
        return Key.of(key);
    }

    @Override
    public void runTask(Runnable runnable) {
        this.runTask.accept(runnable);
    }

    @Override
    public void scheduleSyncRepeatingTask(Runnable runnable, long delay, long period) {
        this.taskScheduler.scheduleSyncRepeatingTask(runnable, delay, period);
    }

    @Override
    public String getBaseBukkitPackage() {
        return this.baseBukkitPackage;
    }

    @Override
    public String getBaseServerPackage() {
        return this.baseServerPackage;
    }

    private static interface TaskScheduler {
        public void scheduleSyncRepeatingTask(Runnable var1, long var2, long var4);
    }
}

