/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.compatibility;

import com.mojang.brigadier.arguments.ArgumentType;
import de.maxhenkel.voicechat.compatibility.CompatibilityReflectionException;
import de.maxhenkel.voicechat.util.Key;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public interface Compatibility {
    default public void init() throws Exception {
    }

    public void addChannel(Player var1, String var2);

    public void removeChannel(Player var1, String var2);

    public Key createNamespacedKey(String var1);

    public void sendTranslationMessage(Player var1, String var2, String ... var3);

    public void sendStatusMessage(Player var1, String var2, String ... var3);

    public void sendInviteMessage(Player var1, Player var2, String var3, String var4);

    public void sendIncompatibleMessage(Player var1, String var2, String var3);

    public void runTask(Runnable var1);

    public void scheduleSyncRepeatingTask(Runnable var1, long var2, long var4);

    @Nullable
    public ArgumentType<?> playerArgument();

    @Nullable
    public ArgumentType<?> uuidArgument();

    public String getBaseBukkitPackage();

    public String getBaseServerPackage();

    default public Class<?> getBukkitClass(String ... classNames) {
        for (String className : classNames) {
            try {
                return Class.forName(String.format("%s.%s", this.getBaseBukkitPackage(), className));
            }
            catch (Throwable throwable) {
            }
        }
        throw new CompatibilityReflectionException(String.format("Could not find any of the following classes: %s", String.join((CharSequence)", ", classNames)));
    }

    default public Class<?> getServerClass(String ... classNames) {
        for (String className : classNames) {
            try {
                return Class.forName(String.format("%s.%s", this.getBaseServerPackage(), className));
            }
            catch (Throwable throwable) {
            }
        }
        throw new CompatibilityReflectionException(String.format("Could not find any of the following classes: %s", String.join((CharSequence)", ", classNames)));
    }
}

