/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.compatibility;

import com.mojang.brigadier.arguments.ArgumentType;
import de.maxhenkel.voicechat.BukkitVersion;
import de.maxhenkel.voicechat.compatibility.Compatibility1_8;
import de.maxhenkel.voicechat.compatibility.JsonMessageBaseCompatibility;
import de.maxhenkel.voicechat.compatibility.ReflectionUtils;
import java.lang.reflect.Method;
import org.bukkit.entity.Player;

public class Compatibility1_20_3
extends JsonMessageBaseCompatibility {
    public static final BukkitVersion VERSION_1_20_3 = BukkitVersion.parseBukkitVersion("1.20.3-R0.1");
    public static final BukkitVersion VERSION_1_20_4 = BukkitVersion.parseBukkitVersion("1.20.4-R0.1");
    public static final BukkitVersion VERSION_1_20_5 = BukkitVersion.parseBukkitVersion("1.20.5-R0.1");
    public static final BukkitVersion VERSION_1_20_6 = BukkitVersion.parseBukkitVersion("1.20.6-R0.1");
    public static final BukkitVersion VERSION_1_21 = BukkitVersion.parseBukkitVersion("1.21-R0.1");
    public static final BukkitVersion VERSION_1_21_1 = BukkitVersion.parseBukkitVersion("1.21.1-R0.1");
    public static final BukkitVersion VERSION_1_21_2 = BukkitVersion.parseBukkitVersion("1.21.2-R0.1");
    public static final BukkitVersion VERSION_1_21_3 = BukkitVersion.parseBukkitVersion("1.21.3-R0.1");
    public static final BukkitVersion VERSION_1_21_4 = BukkitVersion.parseBukkitVersion("1.21.4-R0.1");
    public static final Compatibility1_20_3 INSTANCE = new Compatibility1_20_3();
    private Method playerArgument;
    private Method uuidArgument;
    private Method fromJson;
    private Method getHandle;
    private Method sendSystemMessage;

    @Override
    public void init() throws Exception {
        super.init();
        Class<?> argumentEntityClass = ReflectionUtils.getClazz("net.minecraft.commands.arguments.ArgumentEntity", "net.minecraft.commands.arguments.EntityArgument");
        this.playerArgument = ReflectionUtils.getMethod(argumentEntityClass, "c", "entity");
        Class<?> argumentUuidClass = ReflectionUtils.getClazz("net.minecraft.commands.arguments.ArgumentUUID", "net.minecraft.commands.arguments.UuidArgument");
        this.uuidArgument = ReflectionUtils.getMethod(argumentUuidClass, "a", "uuid");
        Class<?> craftPlayer = this.getBukkitClass("entity.CraftPlayer");
        this.getHandle = ReflectionUtils.getMethod(craftPlayer, "getHandle");
        Class<?> componentClass = ReflectionUtils.getClazz("net.minecraft.network.chat.IChatBaseComponent", "net.minecraft.network.chat.Component");
        Class<?> craftChatMessageClass = this.getBukkitClass("util.CraftChatMessage");
        this.fromJson = ReflectionUtils.getMethod(craftChatMessageClass, new String[]{"fromJSON"}, new Class[]{String.class});
        Class<?> player = ReflectionUtils.getClazz("net.minecraft.server.level.EntityPlayer");
        this.sendSystemMessage = ReflectionUtils.getMethod(player, new String[]{"a", "sendSystemMessage"}, new Class[]{componentClass, Boolean.TYPE});
    }

    @Override
    public void sendJsonMessage(Player player, String json) {
        this.send(player, json, false);
    }

    @Override
    public void sendJsonStatusMessage(Player player, String json) {
        this.send(player, json, true);
    }

    @Override
    public String createTranslationMessage(String key, String ... args) {
        return Compatibility1_8.constructTranslationMessage(key, args);
    }

    @Override
    public void sendInviteMessage(Player player, Player commandSender, String groupName, String joinCommand) {
        this.sendJsonMessage(player, Compatibility1_8.constructInviteMessage(commandSender, groupName, joinCommand));
    }

    @Override
    public void sendIncompatibleMessage(Player player, String pluginVersion, String pluginName) {
        this.sendJsonMessage(player, Compatibility1_8.constructIncompatibleMessage(pluginVersion, pluginName));
    }

    @Override
    public ArgumentType<?> playerArgument() {
        return (ArgumentType)ReflectionUtils.call(this.playerArgument, null, new Object[0]);
    }

    @Override
    public ArgumentType<?> uuidArgument() {
        return (ArgumentType)ReflectionUtils.call(this.uuidArgument, null, new Object[0]);
    }

    protected void send(Player player, String json, boolean status) {
        ReflectionUtils.call(this.sendSystemMessage, ReflectionUtils.call(this.getHandle, player, new Object[0]), ReflectionUtils.call(this.fromJson, null, json), status);
    }
}

