/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.opus;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.concentus.OpusException;
import javax.annotation.Nullable;

public class JavaOpusDecoderImpl
implements OpusDecoder {
    protected de.maxhenkel.voicechat.concentus.OpusDecoder opusDecoder;
    protected short[] buffer;
    protected int sampleRate;
    protected int frameSize;
    protected int maxPayloadSize;

    public JavaOpusDecoderImpl(int sampleRate, int frameSize, int maxPayloadSize) {
        this.sampleRate = sampleRate;
        this.frameSize = frameSize;
        this.maxPayloadSize = maxPayloadSize;
        this.buffer = new short[4096];
        this.open();
    }

    private void open() {
        if (this.opusDecoder != null) {
            return;
        }
        try {
            this.opusDecoder = new de.maxhenkel.voicechat.concentus.OpusDecoder(this.sampleRate, 1);
        }
        catch (OpusException e) {
            throw new IllegalStateException("Opus decoder error " + e.getMessage());
        }
        Voicechat.LOGGER.debug("Initializing Opus decoder with sample rate {} Hz, frame size {} bytes and max payload size {} bytes", this.sampleRate, this.frameSize, this.maxPayloadSize);
    }

    @Override
    public short[] decode(@Nullable byte[] data) {
        int result;
        if (this.isClosed()) {
            throw new IllegalStateException("Decoder is closed");
        }
        try {
            result = data == null || data.length == 0 ? this.opusDecoder.decode(null, 0, 0, this.buffer, 0, this.frameSize, false) : this.opusDecoder.decode(data, 0, data.length, this.buffer, 0, this.frameSize, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to decode audio data: " + e.getMessage());
        }
        short[] audio = new short[result];
        System.arraycopy(this.buffer, 0, audio, 0, result);
        return audio;
    }

    @Override
    public boolean isClosed() {
        return this.opusDecoder == null;
    }

    @Override
    public void close() {
        if (this.opusDecoder == null) {
            return;
        }
        this.opusDecoder = null;
    }

    @Override
    public void resetState() {
        if (this.isClosed()) {
            throw new IllegalStateException("Decoder is closed");
        }
        this.opusDecoder.resetState();
    }
}

