/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.integration.freecam;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.integration.freecam.FreecamMode;
import de.maxhenkel.voicechat.voice.client.PositionalAudioUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;

public class FreecamUtil {
    private static final Minecraft mc = Minecraft.getInstance();

    public static boolean isFreecamEnabled() {
        if (FreecamUtil.mc.player == null) {
            return false;
        }
        return VoicechatClient.CLIENT_CONFIG.freecamMode.get().equals((Object)FreecamMode.PLAYER) && !FreecamUtil.mc.player.isSpectator() && !FreecamUtil.mc.player.equals((Object)mc.getCameraEntity());
    }

    public static Vec3 getReferencePoint() {
        if (FreecamUtil.mc.player == null) {
            return Vec3.ZERO;
        }
        return FreecamUtil.isFreecamEnabled() ? FreecamUtil.mc.player.getEyePosition() : FreecamUtil.mc.gameRenderer.getMainCamera().position();
    }

    public static double getDistanceTo(Vec3 pos) {
        return FreecamUtil.getReferencePoint().distanceTo(pos);
    }

    public static float getDistanceVolume(float maxDistance, Vec3 pos) {
        return PositionalAudioUtils.getDistanceVolume(maxDistance, FreecamUtil.getReferencePoint(), pos);
    }
}

