/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class ChatUtils {
    public static void sendModErrorMessage(String translationKey, @Nullable String errorMessage) {
        MutableComponent error = ChatUtils.createModMessage((Component)Component.translatable((String)translationKey).withStyle(ChatFormatting.RED)).withStyle(style -> {
            if (errorMessage != null) {
                return style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)errorMessage).withStyle(ChatFormatting.RED)));
            }
            return style;
        });
        ChatUtils.sendPlayerMessage((Component)error);
    }

    public static void sendModErrorMessage(String translationKey, @Nullable Exception e) {
        ChatUtils.sendModErrorMessage(translationKey, e == null ? null : e.getMessage());
    }

    public static void sendModErrorMessage(String translationKey) {
        ChatUtils.sendModErrorMessage(translationKey, (String)null);
    }

    public static void sendModMessage(Component message) {
        ChatUtils.sendPlayerMessage((Component)ChatUtils.createModMessage(message));
    }

    public static MutableComponent createModMessage(Component message) {
        return Component.empty().append((Component)ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)CommonCompatibilityManager.INSTANCE.getModName())).withStyle(ChatFormatting.GREEN)).append(" ").append(message);
    }

    public static void sendPlayerMessage(Component component) {
        Minecraft.getInstance().gui.getChat().addMessage(component);
    }
}

