/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingManager;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.plugins.ClientPluginManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class RenderEvents {
    private static final Identifier MICROPHONE_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone.png");
    private static final Identifier WHISPER_MICROPHONE_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone_whisper.png");
    private static final Identifier MICROPHONE_OFF_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone_off.png");
    private static final Identifier SPEAKER_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker.png");
    private static final Identifier WHISPER_SPEAKER_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker_whisper.png");
    private static final Identifier SPEAKER_OFF_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker_off.png");
    private static final Identifier DISCONNECT_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/disconnected.png");
    private static final Identifier GROUP_ICON = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/group.png");
    private final Minecraft minecraft = Minecraft.getInstance();

    public RenderEvents() {
        ClientCompatibilityManager.INSTANCE.onRenderNamePlate(this::onRenderName);
        ClientCompatibilityManager.INSTANCE.onRenderHUD(this::onRenderHUD);
    }

    private void onRenderHUD(GuiGraphics guiGraphics, float tickDelta) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!VoicechatClient.CLIENT_CONFIG.showHudIcons.get().booleanValue()) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        if (manager.isDisconnected() && this.isStartup()) {
            return;
        }
        if (manager.isDisconnected()) {
            this.renderIcon(guiGraphics, DISCONNECT_ICON);
        } else if (manager.isDisabled()) {
            this.renderIcon(guiGraphics, SPEAKER_OFF_ICON);
        } else if (manager.isMuted() && VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE)) {
            this.renderIcon(guiGraphics, MICROPHONE_OFF_ICON);
        } else if (client != null && client.getMicThread() != null) {
            if (client.getMicThread().isWhispering()) {
                this.renderIcon(guiGraphics, WHISPER_MICROPHONE_ICON);
            } else if (client.getMicThread().isTalking()) {
                this.renderIcon(guiGraphics, MICROPHONE_ICON);
            }
        }
        if (manager.getGroupID() != null && VoicechatClient.CLIENT_CONFIG.showGroupHud.get().booleanValue()) {
            GroupChatManager.renderIcons(guiGraphics);
        }
    }

    private boolean isStartup() {
        ClientVoicechat client = ClientManager.getClient();
        return client != null && System.currentTimeMillis() - client.getStartTime() < 5000L;
    }

    private void renderIcon(GuiGraphics guiGraphics, Identifier texture) {
        guiGraphics.pose().pushMatrix();
        int posX = VoicechatClient.CLIENT_CONFIG.hudIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.hudIconPosY.get();
        if (posX < 0) {
            guiGraphics.pose().translate((float)this.minecraft.getWindow().getGuiScaledWidth(), 0.0f);
        }
        if (posY < 0) {
            guiGraphics.pose().translate(0.0f, (float)this.minecraft.getWindow().getGuiScaledHeight());
        }
        guiGraphics.pose().translate((float)posX, (float)posY);
        float scale = VoicechatClient.CLIENT_CONFIG.hudIconScale.get().floatValue();
        guiGraphics.pose().scale(scale, scale);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, posX < 0 ? -16 : 0, posY < 0 ? -16 : 0, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.pose().popMatrix();
    }

    private void onRenderName(EntityRenderState s, CameraRenderState cameraRenderState, PoseStack stack, SubmitNodeCollector collector) {
        if (!(s instanceof AvatarRenderState)) {
            return;
        }
        AvatarRenderState state = (AvatarRenderState)s;
        Component nameTag = s.nameTag;
        if (nameTag == null) {
            return;
        }
        if (s.nameTagAttachment == null) {
            return;
        }
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!VoicechatClient.CLIENT_CONFIG.showNametagIcons.get().booleanValue()) {
            return;
        }
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        Entity entity = this.minecraft.level.getEntity(state.id);
        if (entity == null || entity.equals((Object)this.minecraft.player)) {
            return;
        }
        if (this.minecraft.options.hideGui) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        UUID entityId = entity.getUUID();
        UUID groupId = manager.getGroup(entityId);
        stack.pushPose();
        stack.translate(state.nameTagAttachment);
        stack.translate(0.0, 0.5, 0.0);
        stack.mulPose((Quaternionfc)cameraRenderState.orientation);
        stack.scale(0.025f, -0.025f, 0.025f);
        if (client != null && client.getTalkCache().isWhispering(entityId)) {
            this.renderPlayerIcon(entityId, state.isDiscrete, nameTag, WHISPER_SPEAKER_ICON, stack, collector, state.lightCoords);
        } else if (client != null && client.getTalkCache().isTalking(entityId)) {
            this.renderPlayerIcon(entityId, state.isDiscrete, nameTag, SPEAKER_ICON, stack, collector, state.lightCoords);
        } else if (manager.isPlayerDisconnected(entityId)) {
            this.renderPlayerIcon(entityId, state.isDiscrete, nameTag, DISCONNECT_ICON, stack, collector, state.lightCoords);
        } else if (groupId != null && !groupId.equals(manager.getGroupID())) {
            this.renderPlayerIcon(entityId, state.isDiscrete, nameTag, GROUP_ICON, stack, collector, state.lightCoords);
        } else if (manager.isPlayerDisabled(entityId)) {
            this.renderPlayerIcon(entityId, state.isDiscrete, nameTag, SPEAKER_OFF_ICON, stack, collector, state.lightCoords);
        }
        stack.popPose();
    }

    private void renderPlayerIcon(UUID entityId, boolean discrete, Component component, Identifier texture, PoseStack stack, SubmitNodeCollector collector, int light) {
        if (!ClientPluginManager.instance().shouldRenderPlayerIcons(entityId)) {
            return;
        }
        float offsetX = this.minecraft.font.width((FormattedText)component) / 2 + 2;
        int alpha = 32;
        float offsetY = -1.0f;
        collector.submitCustomGeometry(stack, RenderTypes.text((Identifier)texture), (pose, c) -> {
            if (discrete) {
                RenderEvents.vertex(c, pose, offsetX, 10.0f + offsetY, 0.0f, 0.0f, 1.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, 10.0f + offsetY, 0.0f, 1.0f, 1.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, offsetY, 0.0f, 1.0f, 0.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX, offsetY, 0.0f, 0.0f, 0.0f, alpha, light);
            } else {
                RenderEvents.vertex(c, pose, offsetX, 10.0f + offsetY, 0.0f, 0.0f, 1.0f, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, 10.0f + offsetY, 0.0f, 1.0f, 1.0f, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, offsetY, 0.0f, 1.0f, 0.0f, light);
                RenderEvents.vertex(c, pose, offsetX, offsetY, 0.0f, 0.0f, 0.0f, light);
            }
        });
        if (!discrete) {
            collector.submitCustomGeometry(stack, RenderTypes.textSeeThrough((Identifier)texture), (pose, c) -> {
                RenderEvents.vertex(c, pose, offsetX, 10.0f + offsetY, 0.0f, 0.0f, 1.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, 10.0f + offsetY, 0.0f, 1.0f, 1.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, offsetY, 0.0f, 1.0f, 0.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX, offsetY, 0.0f, 0.0f, 0.0f, alpha, light);
            });
        }
    }

    private boolean shouldShowIcons() {
        if (OnboardingManager.isOnboarding()) {
            return false;
        }
        if (ClientManager.getClient() != null && ClientManager.getClient().getConnection() != null && ClientManager.getClient().getConnection().isInitialized()) {
            return true;
        }
        return this.minecraft.getSingleplayerServer() == null || this.minecraft.getSingleplayerServer().isPublished();
    }

    private static void vertex(VertexConsumer builder, PoseStack.Pose pose, float x, float y, float z, float u, float v, int light) {
        RenderEvents.vertex(builder, pose, x, y, z, u, v, 255, light);
    }

    private static void vertex(VertexConsumer builder, PoseStack.Pose pose, float x, float y, float z, float u, float v, int alpha, int light) {
        builder.addVertex((Matrix4fc)pose.pose(), x, y, z).setColor(255, 255, 255, alpha).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
    }
}

