/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.group.GroupList;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideGroupHudTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Collections;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class GroupScreen
extends ListScreenBase {
    protected static final class_2960 TEXTURE = new class_2960("voicechat", "textures/gui/gui_group.png");
    protected static final class_2960 LEAVE = new class_2960("voicechat", "textures/icons/leave.png");
    protected static final class_2960 MICROPHONE = new class_2960("voicechat", "textures/icons/microphone_button.png");
    protected static final class_2960 SPEAKER = new class_2960("voicechat", "textures/icons/speaker_button.png");
    protected static final class_2960 GROUP_HUD = new class_2960("voicechat", "textures/icons/group_hud_button.png");
    protected static final class_2561 TITLE = new class_2588("gui.voicechat.group.title");
    protected static final class_2561 LEAVE_GROUP = new class_2588("message.voicechat.leave_group");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected GroupList groupList;
    protected int units;
    protected final ClientGroup group;
    protected ToggleImageButton mute;
    protected ToggleImageButton disable;
    protected ToggleImageButton showHUD;
    protected ImageButton leave;

    public GroupScreen(ClientGroup group) {
        super(TITLE, 236, 0);
        this.group = group;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = class_3532.method_15386((float)2.2222223f);
        this.units = Math.max(minUnits, (this.field_22790 - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();
        if (this.groupList != null) {
            this.groupList.updateSize(this.field_22789, this.units * 18, this.guiTop + 16);
        } else {
            this.groupList = new GroupList(this, this.field_22789, this.units * 18, this.guiTop + 16, 36);
        }
        this.method_25429((class_364)this.groupList);
        int buttonY = this.guiTop + this.ySize - 20 - 7;
        int buttonSize = 20;
        this.mute = new ToggleImageButton(this.guiLeft + 7, buttonY, MICROPHONE, stateManager::isMuted, button -> stateManager.setMuted(!stateManager.isMuted()), new MuteTooltipSupplier(this, stateManager));
        this.method_25411((class_339)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 7 + buttonSize + 3, buttonY, SPEAKER, stateManager::isDisabled, button -> stateManager.setDisabled(!stateManager.isDisabled()), new DisableTooltipSupplier(this, stateManager));
        this.method_25411((class_339)this.disable);
        this.showHUD = new ToggleImageButton(this.guiLeft + 7 + (buttonSize + 3) * 2, buttonY, GROUP_HUD, VoicechatClient.CLIENT_CONFIG.showGroupHud::get, button -> VoicechatClient.CLIENT_CONFIG.showGroupHud.set(VoicechatClient.CLIENT_CONFIG.showGroupHud.get() == false).save(), new HideGroupHudTooltipSupplier(this));
        this.method_25411((class_339)this.showHUD);
        this.leave = new ImageButton(this.guiLeft + this.xSize - buttonSize - 7, buttonY, LEAVE, button -> {
            ClientServerNetManager.sendToServer(new LeaveGroupPacket());
            this.field_22787.method_1507((class_437)new JoinGroupScreen());
        }, (button, matrices, mouseX, mouseY) -> this.method_25417(matrices, Collections.singletonList(LEAVE_GROUP.method_30937()), mouseX, mouseY));
        this.method_25411((class_339)this.leave);
        this.checkButtons();
    }

    public void method_25393() {
        super.method_25393();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.field_22763 = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE);
        this.showHUD.field_22763 = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
    }

    @Override
    public void renderBackground(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        this.field_22787.method_1531().method_22813(TEXTURE);
        this.method_25302(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            this.method_25302(poseStack, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        this.method_25302(poseStack, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        this.method_25302(poseStack, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        class_2588 title = this.group.getType().equals(Group.Type.NORMAL) ? new class_2588("message.voicechat.group_title", new Object[]{new class_2585(this.group.getName())}) : new class_2588("message.voicechat.group_type_title", new Object[]{new class_2585(this.group.getName()), GroupType.fromType(this.group.getType()).getTranslation()});
        this.field_22793.method_30883(poseStack, (class_2561)title, (float)(this.guiLeft + this.xSize / 2 - this.field_22793.method_27525((class_5348)title) / 2), (float)(this.guiTop + 5), 0x404040);
        this.groupList.method_25394(poseStack, mouseX, mouseY, delta);
    }
}

