/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class JoinGroupEntry
extends ListScreenEntryBase<JoinGroupEntry> {
    protected static final class_2960 LOCK = new class_2960("voicechat", "textures/icons/lock.png");
    protected static final class_2561 GROUP_MEMBERS = new class_2588("message.voicechat.group_members").method_27692(class_124.field_1080);
    protected static final class_2561 NO_GROUP_MEMBERS = new class_2588("message.voicechat.no_group_members").method_27692(class_124.field_1080);
    protected static final int SKIN_SIZE = 12;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = class_5253.class_5254.method_27764((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_SELECTED = class_5253.class_5254.method_27764((int)255, (int)90, (int)90, (int)90);
    protected static final int PLAYER_NAME_COLOR = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
    protected final ListScreenBase parent;
    protected final class_310 minecraft;
    protected final Group group;

    public JoinGroupEntry(ListScreenBase parent, Group group) {
        this.parent = parent;
        this.minecraft = class_310.method_1551();
        this.group = group;
    }

    public void method_25343(class_4587 poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        if (hovered) {
            class_332.method_25294((class_4587)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL_SELECTED);
        } else {
            class_332.method_25294((class_4587)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL);
        }
        boolean hasPassword = this.group.group.hasPassword();
        if (hasPassword) {
            poseStack.method_22903();
            poseStack.method_22904((double)(left + 4), (double)((float)top + (float)height / 2.0f - 8.0f), 0.0);
            poseStack.method_22905(1.3333334f, 1.3333334f, 1.0f);
            this.minecraft.method_1531().method_22813(LOCK);
            class_437.method_25290((class_4587)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)12, (int)12, (int)16, (int)16);
            poseStack.method_22909();
        }
        class_2585 groupName = new class_2585(this.group.group.getName());
        class_327 class_3272 = this.minecraft.field_1772;
        float f = left + 4 + (hasPassword ? 20 : 0);
        int n = top + height / 2;
        this.minecraft.field_1772.getClass();
        class_3272.method_30883(poseStack, (class_2561)groupName, f, (float)(n - 9 / 2), PLAYER_NAME_COLOR);
        int textWidth = this.minecraft.field_1772.method_27525((class_5348)groupName) + (hasPassword ? 20 : 0);
        int headsPerRow = (width - (4 + textWidth + 4 + 4)) / 13;
        int rows = 2;
        for (int i = 0; i < this.group.members.size(); ++i) {
            PlayerState state = (PlayerState)this.group.members.get(i);
            int headXIndex = i / rows;
            int headYIndex = i % rows;
            if (i >= headsPerRow * rows) break;
            int headPosX = left + width - 12 - 4 - headXIndex * 13;
            int headPosY = top + height / 2 - 13 + 13 * headYIndex;
            poseStack.method_22903();
            this.minecraft.method_1531().method_22813(GameProfileUtils.getSkin(state.getUuid()));
            poseStack.method_22904((double)headPosX, (double)headPosY, 0.0);
            float scale = 1.5f;
            poseStack.method_22905(scale, scale, scale);
            class_437.method_25290((class_4587)poseStack, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.enableBlend();
            class_437.method_25290((class_4587)poseStack, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
            poseStack.method_22909();
        }
        if (!hovered) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        if (this.group.getGroup().getType().equals(Group.Type.NORMAL)) {
            tooltip.add(new class_2588("message.voicechat.group_title", new Object[]{new class_2585(this.group.getGroup().getName())}).method_30937());
        } else {
            tooltip.add(new class_2588("message.voicechat.group_type_title", new Object[]{new class_2585(this.group.getGroup().getName()), GroupType.fromType(this.group.getGroup().getType()).getTranslation()}).method_30937());
        }
        if (this.group.getMembers().isEmpty()) {
            tooltip.add(NO_GROUP_MEMBERS.method_30937());
        } else {
            tooltip.add(GROUP_MEMBERS.method_30937());
            int maxMembers = 10;
            for (int i = 0; i < this.group.getMembers().size(); ++i) {
                if (i >= maxMembers) {
                    tooltip.add(new class_2588("message.voicechat.more_members", new Object[]{this.group.getMembers().size() - maxMembers}).method_27692(class_124.field_1080).method_30937());
                    break;
                }
                PlayerState state = this.group.getMembers().get(i);
                tooltip.add(new class_2585("  " + state.getName()).method_27692(class_124.field_1080).method_30937());
            }
        }
        this.parent.postRender(() -> this.parent.method_25417(poseStack, tooltip, mouseX, mouseY));
    }

    public Group getGroup() {
        return this.group;
    }

    public static class Group {
        private final ClientGroup group;
        private final List<PlayerState> members;

        public Group(ClientGroup group) {
            this.group = group;
            this.members = new ArrayList<PlayerState>();
        }

        public ClientGroup getGroup() {
            return this.group;
        }

        public List<PlayerState> getMembers() {
            return this.members;
        }
    }
}

