/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1297;

public class TalkCache {
    private static final long TIMEOUT = 250L;
    private static final PlayerCache DEFAULT = new PlayerCache(0L, false, -127.0);
    private final Map<UUID, PlayerCache> playerCache = new HashMap<UUID, PlayerCache>();
    private final Map<String, CategoryCache> categoryCache = new HashMap<String, CategoryCache>();
    private Supplier<Long> timestampSupplier = System::currentTimeMillis;

    public void setTimestampSupplier(Supplier<Long> timestampSupplier) {
        this.timestampSupplier = timestampSupplier;
    }

    private void updateTalking(UUID entity, boolean whispering, double audioLevel) {
        PlayerCache talk = this.playerCache.get(entity);
        if (talk == null) {
            talk = new PlayerCache(this.timestampSupplier.get(), whispering, audioLevel);
            this.playerCache.put(entity, talk);
        } else {
            talk.timestamp = this.timestampSupplier.get();
            talk.whispering = whispering;
            talk.audioLevel = audioLevel;
        }
    }

    public void updateLevel(UUID id, @Nullable String category, boolean whispering, short[] audio) {
        double highestAudioLevel = AudioUtils.getHighestAudioLevel(audio);
        if (category != null) {
            this.updateCategoryVolume(category, highestAudioLevel);
        }
        this.updateTalking(id, whispering, highestAudioLevel);
    }

    public boolean isTalking(class_1297 entity) {
        return this.isTalking(entity.method_5667());
    }

    public boolean isWhispering(class_1297 entity) {
        return this.isWhispering(entity.method_5667());
    }

    public boolean isTalking(UUID entity) {
        ClientVoicechat client;
        if (entity.equals(ClientManager.getPlayerStateManager().getOwnID()) && (client = ClientManager.getClient()) != null && client.getMicThread() != null && client.getMicThread().isTalking()) {
            return true;
        }
        PlayerCache lastTalk = this.playerCache.getOrDefault(entity, DEFAULT);
        return this.timestampSupplier.get() - lastTalk.timestamp < 250L;
    }

    public boolean isWhispering(UUID entity) {
        ClientVoicechat client;
        if (entity.equals(ClientManager.getPlayerStateManager().getOwnID()) && (client = ClientManager.getClient()) != null && client.getMicThread() != null && client.getMicThread().isWhispering()) {
            return true;
        }
        PlayerCache lastTalk = this.playerCache.getOrDefault(entity, DEFAULT);
        return lastTalk.whispering && this.timestampSupplier.get() - lastTalk.timestamp < 250L;
    }

    public void updateCategoryVolume(String category, double audioLevel) {
        CategoryCache cache = this.categoryCache.get(category);
        if (cache == null) {
            cache = new CategoryCache(this.timestampSupplier.get(), audioLevel);
            this.categoryCache.put(category, cache);
        } else {
            cache.timestamp = this.timestampSupplier.get();
            cache.audioLevel = audioLevel;
        }
    }

    public double getPlayerAudioLevel(UUID entity) {
        PlayerCache talk = this.playerCache.getOrDefault(entity, DEFAULT);
        if (this.timestampSupplier.get() - talk.timestamp >= 250L) {
            return -127.0;
        }
        return talk.audioLevel;
    }

    public double getCategoryAudioLevel(String category) {
        CategoryCache cache = this.categoryCache.get(category);
        if (cache == null) {
            return -127.0;
        }
        if (this.timestampSupplier.get() - cache.timestamp >= 250L) {
            return -127.0;
        }
        return cache.audioLevel;
    }

    private static class CategoryCache {
        private long timestamp;
        private double audioLevel;

        public CategoryCache(long timestamp, double audioLevel) {
            this.timestamp = timestamp;
            this.audioLevel = audioLevel;
        }
    }

    private static class PlayerCache {
        private long timestamp;
        private boolean whispering;
        private double audioLevel;

        public PlayerCache(long timestamp, boolean whispering, double audioLevel) {
            this.timestamp = timestamp;
            this.whispering = whispering;
            this.audioLevel = audioLevel;
        }
    }
}

