/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class AdjustVolumeSlider
extends DebouncedSlider {
    protected static final class_2561 MUTED = new class_2588("message.voicechat.muted");
    protected static final double YELLOW_DB = -20.0;
    protected static final double RED_DB = -6.0;
    protected static final float MAXIMUM = 4.0f;
    protected final AdjustVolumeEntry volumeConfigEntry;

    public AdjustVolumeSlider(int xIn, int yIn, int widthIn, int heightIn, AdjustVolumeEntry volumeConfigEntry) {
        super(xIn, yIn, widthIn, heightIn, (class_2561)new class_2585(""), volumeConfigEntry.get() / 4.0);
        this.volumeConfigEntry = volumeConfigEntry;
        this.method_25346();
    }

    protected void method_25346() {
        if (this.field_22753 <= 0.0) {
            this.method_25355(MUTED);
            return;
        }
        long amp = Math.round(this.field_22753 * 4.0 * 100.0 - 100.0);
        this.method_25355((class_2561)new class_2588("message.voicechat.volume_amplification", new Object[]{((float)amp > 0.0f ? "+" : "") + amp + "%"}));
    }

    public void method_25394(class_4587 matrixStack, int i, int j, float f) {
        super.method_25394(matrixStack, i, j, f);
        double audioLevel = this.volumeConfigEntry.getAudioLevel();
        if (audioLevel <= -127.0) {
            return;
        }
        double adjustedLevel = AudioUtils.linearToDb(this.getMultiplier());
        int barWidth = (int)((double)this.method_25368() * AudioUtils.dbToPerc(audioLevel + adjustedLevel));
        double yellowPerc = AudioUtils.dbToPerc(-20.0);
        double redPerc = AudioUtils.dbToPerc(-6.0);
        int greenWidth = (int)((double)this.method_25368() * yellowPerc);
        int yellowWidth = (int)((double)this.method_25368() * redPerc) - greenWidth;
        int width = this.method_25368();
        class_437.method_25294((class_4587)matrixStack, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + Math.min(greenWidth, barWidth)), (int)(this.field_22761 + 1), (int)-16711936);
        if (barWidth > greenWidth) {
            class_437.method_25294((class_4587)matrixStack, (int)(this.field_22760 + greenWidth), (int)this.field_22761, (int)(this.field_22760 + Math.min(greenWidth + yellowWidth, barWidth)), (int)(this.field_22761 + 1), (int)-256);
            if (barWidth > greenWidth + yellowWidth) {
                class_437.method_25294((class_4587)matrixStack, (int)(this.field_22760 + greenWidth + yellowWidth), (int)this.field_22761, (int)(this.field_22760 + Math.min(width, barWidth)), (int)(this.field_22761 + 1), (int)-65536);
            }
        }
    }

    @Override
    public void applyDebounced() {
        this.volumeConfigEntry.save(this.getMultiplier());
    }

    private double getMultiplier() {
        return this.field_22753 * 4.0;
    }

    public static interface AdjustVolumeEntry {
        public void save(double var1);

        public double get();

        public double getAudioLevel();
    }
}

