/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.resourcepacks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.maxhenkel.voicechat.Voicechat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_5352;

public class VoiceChatResourcePack
extends class_3255 {
    protected String path;
    protected class_2554 name;

    public VoiceChatResourcePack(String path, class_2554 name) {
        super(null);
        this.path = path;
        this.name = name;
    }

    @Nullable
    public class_3288 toPack() {
        try {
            class_3272 packMetadataSection = (class_3272)this.method_14407((class_3270)class_3272.field_14202);
            if (packMetadataSection == null) {
                return null;
            }
            return new class_3288(this.path, false, () -> this, (class_2561)this.name, packMetadataSection.method_14423(), class_3281.field_14224, class_3288.class_3289.field_14280, false, class_5352.field_25348);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String method_14409() {
        return this.path;
    }

    private String getPath() {
        return "/packs/" + this.path + "/";
    }

    @Nullable
    private InputStream get(String name) {
        return Voicechat.class.getResourceAsStream(this.getPath() + name);
    }

    protected InputStream method_14391(String name) throws IOException {
        InputStream resourceAsStream = this.get(name);
        if (resourceAsStream == null) {
            throw new FileNotFoundException("Resource " + name + " does not exist");
        }
        return resourceAsStream;
    }

    protected boolean method_14393(String name) {
        try {
            return this.get(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        ArrayList list = Lists.newArrayList();
        try {
            URL url = Voicechat.class.getResource(this.getPath());
            Path namespacePath = Paths.get(url.toURI()).resolve(type.method_14413()).resolve(namespace);
            Path resPath = namespacePath.resolve(prefix);
            if (!Files.exists(resPath, new LinkOption[0])) {
                return list;
            }
            try (Stream<Path> files = Files.walk(resPath, new FileVisitOption[0]);){
                files.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    class_2960 resourceLocation = new class_2960(namespace, VoiceChatResourcePack.convertPath(path).substring(VoiceChatResourcePack.convertPath(namespacePath).length() + 1));
                    list.add(resourceLocation);
                });
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to list builtin pack resources", e);
        }
        return list.stream().filter(resourceLocation -> pathFilter.test(resourceLocation.method_12832())).collect(Collectors.toList());
    }

    private static String convertPath(Path path) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < path.getNameCount(); ++i) {
            stringBuilder.append(path.getName(i));
            if (i >= path.getNameCount() - 1) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public Set<String> method_14406(class_3264 packType) {
        if (packType == class_3264.field_14188) {
            return ImmutableSet.of((Object)"voicechat");
        }
        return ImmutableSet.of();
    }

    public void close() {
    }
}

