/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class GroupChatManager {
    private static final class_2960 TALK_OUTLINE = new class_2960("voicechat", "textures/icons/talk_outline.png");
    private static final class_2960 SPEAKER_OFF_ICON = new class_2960("voicechat", "textures/icons/speaker_small_off.png");

    public static void renderIcons(class_4587 matrixStack) {
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        List<PlayerState> groupMembers = GroupChatManager.getGroupMembers(VoicechatClient.CLIENT_CONFIG.showOwnGroupIcon.get());
        matrixStack.method_22903();
        int posX = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosY.get();
        if (posX < 0) {
            matrixStack.method_22904((double)mc.method_22683().method_4486(), 0.0, 0.0);
        }
        if (posY < 0) {
            matrixStack.method_22904(0.0, (double)mc.method_22683().method_4502(), 0.0);
        }
        matrixStack.method_22904((double)posX, (double)posY, 0.0);
        float scale = VoicechatClient.CLIENT_CONFIG.groupHudIconScale.get().floatValue();
        matrixStack.method_22905(scale, scale, 1.0f);
        boolean vertical = VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.get().equals((Object)GroupPlayerIconOrientation.VERTICAL);
        for (int i = 0; i < groupMembers.size(); ++i) {
            PlayerState state = groupMembers.get(i);
            matrixStack.method_22903();
            if (vertical) {
                if (posY < 0) {
                    matrixStack.method_22904(0.0, (double)i * -11.0, 0.0);
                } else {
                    matrixStack.method_22904(0.0, (double)i * 11.0, 0.0);
                }
            } else if (posX < 0) {
                matrixStack.method_22904((double)i * -11.0, 0.0, 0.0);
            } else {
                matrixStack.method_22904((double)i * 11.0, 0.0, 0.0);
            }
            if (client.getTalkCache().isTalking(state.getUuid())) {
                mc.method_1531().method_22813(TALK_OUTLINE);
                class_437.method_25290((class_4587)matrixStack, (int)(posX < 0 ? -10 : 0), (int)(posY < 0 ? -10 : 0), (float)0.0f, (float)0.0f, (int)10, (int)10, (int)16, (int)16);
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            mc.method_1531().method_22813(GameProfileUtils.getSkin(state.getUuid()));
            class_437.method_25290((class_4587)matrixStack, (int)(posX < 0 ? -9 : 1), (int)(posY < 0 ? -9 : 1), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_437.method_25290((class_4587)matrixStack, (int)(posX < 0 ? -9 : 1), (int)(posY < 0 ? -9 : 1), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            if (state.isDisabled()) {
                matrixStack.method_22903();
                matrixStack.method_22904(posX < 0 ? -9.0 : 1.0, posY < 0 ? -9.0 : 1.0, 0.0);
                matrixStack.method_22905(0.5f, 0.5f, 1.0f);
                mc.method_1531().method_22813(SPEAKER_OFF_ICON);
                class_437.method_25290((class_4587)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                matrixStack.method_22909();
            }
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    public static List<PlayerState> getGroupMembers() {
        return GroupChatManager.getGroupMembers(true);
    }

    public static List<PlayerState> getGroupMembers(boolean includeSelf) {
        ArrayList<PlayerState> entries = new ArrayList<PlayerState>();
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            return entries;
        }
        for (PlayerState state : ClientManager.getPlayerStateManager().getPlayerStates(includeSelf)) {
            if (!state.hasGroup() || !state.getGroup().equals(group)) continue;
            entries.add(state);
        }
        entries.sort(Comparator.comparing(PlayerState::getName));
        return entries;
    }
}

