/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client.speaker;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.speaker.ALSpeaker;
import de.maxhenkel.voicechat.voice.client.speaker.ALSpeakerBase;
import de.maxhenkel.voicechat.voice.client.speaker.FakeALSpeaker;
import de.maxhenkel.voicechat.voice.client.speaker.MonoALSpeaker;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import java.util.UUID;
import javax.annotation.Nullable;

public class SpeakerManager {
    public static Speaker createSpeaker(SoundManager soundManager, @Nullable UUID audioChannel) throws SpeakerException {
        ALSpeakerBase speaker;
        switch (VoicechatClient.CLIENT_CONFIG.audioType.get()) {
            default: {
                speaker = new ALSpeaker(soundManager, 48000, 960, audioChannel);
                break;
            }
            case REDUCED: {
                speaker = new FakeALSpeaker(soundManager, 48000, 960, audioChannel);
                break;
            }
            case OFF: {
                speaker = new MonoALSpeaker(soundManager, 48000, 960, audioChannel);
            }
        }
        speaker.open();
        return speaker;
    }
}

