/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.tp.util;

import com.pyding.tp.network.PacketHandler;
import com.pyding.tp.network.packets.ServerToClientSync;
import com.pyding.tp.util.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class TPUtil {
    public static List<Home> homes = TPUtil.parseInput(ConfigHandler.COMMON.homes.get().toString());

    public static String addHome(String input, String name, Player owner) {
        List<Home> homes = TPUtil.parseInput(input);
        int homesCreated = 0;
        for (Home home : homes) {
            if (!owner.m_7755_().getString().equals(home.owner)) continue;
            ++homesCreated;
        }
        if (homesCreated >= (Integer)ConfigHandler.COMMON.homesPerPlayer.get() && !owner.m_7500_()) {
            owner.m_213846_((Component)Component.m_237113_((String)("Cannot create more than " + ConfigHandler.COMMON.homesPerPlayer.get() + " homes for you.")).m_130940_(ChatFormatting.RED));
        } else {
            Home newHome = new Home();
            newHome.name = name;
            newHome.owner = owner.m_7755_().getString();
            newHome.path = owner.m_20193_().m_46472_().m_135782_().m_135815_();
            newHome.key = owner.m_20193_().m_46472_().m_135782_().m_135827_();
            newHome.x = (int)owner.m_20185_();
            newHome.y = (int)owner.m_20186_();
            newHome.z = (int)owner.m_20189_();
            homes.add(newHome);
            owner.m_213846_((Component)Component.m_237113_((String)("Home " + name + " was created successfully!")).m_130940_(ChatFormatting.GREEN));
        }
        return TPUtil.serializehomes(homes);
    }

    public static void teleportHome(String input, ServerPlayer serverPlayer, String name) {
        if (((Boolean)ConfigHandler.COMMON.shouldNoHit.get()).booleanValue() && TPUtil.wasHitRecently((Player)serverPlayer)) {
            serverPlayer.m_213846_((Component)Component.m_237113_((String)("You shouldn't be hit in " + (Long)ConfigHandler.COMMON.hitTime.get() / 1000L + " seconds before teleportation.")).m_130940_(ChatFormatting.RED));
            return;
        }
        List<Home> homes = TPUtil.parseInput(input);
        boolean found = false;
        for (Home home : homes) {
            if (!home.name.equals(name) || !home.owner.equals(serverPlayer.m_7755_().getString())) continue;
            found = true;
            ServerLevel serverLevel = serverPlayer.m_20193_().m_7654_().m_129880_(TPUtil.getWorldKey(home.path, home.key));
            serverPlayer.m_8999_(serverLevel, (double)home.x, (double)home.y, (double)home.z, 0.0f, 0.0f);
        }
        if (!found) {
            serverPlayer.m_213846_((Component)Component.m_237113_((String)"There is no Home with such name and your ownership.").m_130940_(ChatFormatting.RED));
        }
    }

    public static String removeHome(String input, String name, Player owner) {
        List<Home> homes = TPUtil.parseInput(input);
        for (Home home : homes) {
            if (!home.name.equals(name) || !home.owner.equals(owner.m_7755_().getString())) continue;
            homes.remove(home);
            owner.m_213846_((Component)Component.m_237113_((String)("Home " + name + " was deleted successfully!")).m_130940_(ChatFormatting.GREEN));
            return TPUtil.serializehomes(homes);
        }
        owner.m_213846_((Component)Component.m_237113_((String)"There is no Home with such name and your ownership.").m_130940_(ChatFormatting.RED));
        return TPUtil.serializehomes(homes);
    }

    public static List<Home> parseInput(String input) {
        ArrayList<Home> homes = new ArrayList<Home>();
        Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(input);
        while (matcher.find()) {
            String[] cords;
            String obj = matcher.group(1);
            Home e = new Home();
            TPUtil.extractField(obj, "name", value -> {
                e.name = value;
            });
            TPUtil.extractField(obj, "owner", value -> {
                e.owner = value;
            });
            TPUtil.extractField(obj, "path", value -> {
                e.path = value;
            });
            TPUtil.extractField(obj, "key", value -> {
                e.key = value;
            });
            Matcher m = Pattern.compile("cords\\(([^)]+)\\)").matcher(obj);
            if (m.find() && (cords = m.group(1).split(",")).length == 3) {
                e.x = Integer.parseInt(cords[0].trim());
                e.y = Integer.parseInt(cords[1].trim());
                e.z = Integer.parseInt(cords[2].trim());
            }
            homes.add(e);
        }
        return homes;
    }

    private static String serializehomes(List<Home> homes) {
        return homes.stream().map(e -> String.format("{name(%s)owner(%s)path(%s)key(%s)cords(%d,%d,%d)}", e.name, e.owner, e.path, e.key, e.x, e.y, e.z)).collect(Collectors.joining(","));
    }

    private static void extractField(String obj, String field, Consumer<String> setter) {
        Matcher m = Pattern.compile(field + "\\(([^)]+)\\)").matcher(obj);
        if (m.find()) {
            setter.accept(m.group(1));
        }
    }

    public static void print(Player owner) {
        List<Home> homes = TPUtil.parseInput(ConfigHandler.COMMON.homes.get().toString());
        boolean found = false;
        for (Home home : homes) {
            if (!owner.m_7755_().getString().equals(home.owner)) continue;
            found = true;
            owner.m_213846_((Component)Component.m_237113_((String)"===============================").m_130940_(ChatFormatting.DARK_GRAY));
            owner.m_213846_((Component)Component.m_237113_((String)("Home name: " + home.name)).m_130940_(ChatFormatting.DARK_PURPLE));
            owner.m_213846_((Component)Component.m_237113_((String)("Home owner: " + home.owner)).m_130940_(ChatFormatting.DARK_GREEN));
            owner.m_213846_((Component)Component.m_237113_((String)("Home world: " + home.path + ":" + home.key)).m_130940_(ChatFormatting.DARK_GRAY));
            owner.m_213846_((Component)Component.m_237113_((String)("Home cords: x: " + home.x + " y: " + home.y + " z: " + home.z)).m_130940_(ChatFormatting.GREEN));
            owner.m_213846_((Component)Component.m_237113_((String)"===============================").m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (!found) {
            owner.m_213846_((Component)Component.m_237113_((String)"You have no homes.").m_130940_(ChatFormatting.RED));
        }
    }

    public static void sync() {
        homes = TPUtil.parseInput(ConfigHandler.COMMON.homes.get().toString());
        PacketHandler.sendToClients(PacketDistributor.ALL.noArg(), new ServerToClientSync(ConfigHandler.COMMON.homes.get().toString()));
    }

    public static ResourceKey<Level> getWorldKey(String path, String directory) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(directory, path));
        return key;
    }

    public static void teleportSpawn(ServerPlayer serverPlayer) {
        String path = "";
        String namespace = "";
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int count = 0;
        for (String element : ConfigHandler.COMMON.spawn.get().toString().split(",")) {
            if (count == 0) {
                path = element;
            } else if (count == 1) {
                namespace = element;
            } else if (count == 2) {
                x = Double.parseDouble(element);
            } else if (count == 3) {
                y = Double.parseDouble(element);
            } else if (count == 4) {
                z = Double.parseDouble(element);
            }
            ++count;
        }
        ServerLevel serverLevel = serverPlayer.m_20193_().m_7654_().m_129880_(TPUtil.getWorldKey(path, namespace));
        serverPlayer.m_8999_(serverLevel, x, y, z, 0.0f, 0.0f);
    }

    public static void setSpawnPos(Player player) {
        String path = player.m_20193_().m_46472_().m_135782_().m_135815_();
        String namespace = player.m_20193_().m_46472_().m_135782_().m_135827_();
        ConfigHandler.COMMON.spawn.set((Object)(path + "," + namespace + "," + player.m_20185_() + "," + player.m_20186_() + "," + player.m_20189_() + ","));
        player.m_213846_((Component)Component.m_237113_((String)"Spawn point was created successfully!").m_130940_(ChatFormatting.GREEN));
    }

    public static boolean wasHitRecently(Player player) {
        return player.getPersistentData().m_128454_("TPHit") > System.currentTimeMillis();
    }

    static class Home {
        String name;
        String owner;
        String path;
        String key;
        int x;
        int y;
        int z;

        Home() {
        }
    }
}

