/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.gui;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftcapes.config.MinecraftCapesConfig;
import net.minecraftcapes.player.DownloadManager;

public class MenuScreen
extends Screen {
    public MenuScreen() {
        super((ITextComponent)new StringTextComponent("MinecraftCapes"));
    }

    public void init() {
        int xOffset = this.width / 6 * 4;
        int yOffset = this.height / 3;
        int i = 0;
        this.addButton((Widget)new Button(xOffset - 75, yOffset, 150, 20, "Open MinecraftCapes", button -> this.minecraft.func_147108_a((Screen)new ConfirmOpenLinkScreen(openUrl -> {
            if (openUrl) {
                Util.func_110647_a().func_195640_a("https://minecraftcapes.net");
            }
            this.minecraft.func_147108_a((Screen)this);
        }, "https://minecraftcapes.net", true))));
        ++i;
        this.addButton((Widget)new Button(xOffset - 155 + ++i % 2 * 160, yOffset + 24 * (i >> 1), 150, 20, this.getMessage(GuiOption.CAPE), button -> {
            MinecraftCapesConfig.setCapeVisible(!MinecraftCapesConfig.isCapeVisible());
            button.setMessage(this.getMessage(GuiOption.CAPE));
        }));
        this.addButton((Widget)new Button(xOffset - 155 + ++i % 2 * 160, yOffset + 24 * (i >> 1), 150, 20, this.getMessage(GuiOption.EARS), button -> {
            MinecraftCapesConfig.setEarsVisible(!MinecraftCapesConfig.isEarsVisible());
            button.setMessage(this.getMessage(GuiOption.EARS));
        }));
        ++i;
        this.addButton((Widget)new Button(xOffset - 75, yOffset + 24 * (++i >> 1), 150, 20, "Reload Profile", button -> DownloadManager.prepareDownload(this.minecraft.field_71439_g.func_110124_au(), this.minecraft.field_71439_g.func_200200_C_().getString(), true)));
        this.addButton((Widget)new Button(xOffset - 100, yOffset + 24 * (++i >> 1), 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> this.minecraft.func_147108_a(null)));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        this.renderPlayer(this.width / 6, this.height / 3 + 90, 60, (LivingEntity)this.minecraft.field_71439_g);
        super.render(mouseX, mouseY, partialTicks);
    }

    private void renderPlayer(int x, int y, int scale, LivingEntity livingEntity) {
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)x, (float)y, (float)50.0f);
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float yBodyRot = livingEntity.field_70761_aq;
        float yRot = livingEntity.field_70177_z;
        float xRot = livingEntity.field_70125_A;
        float yHeadRotO = livingEntity.field_70758_at;
        float yHeadRot = livingEntity.field_70759_as;
        RenderHelper.func_74519_b();
        livingEntity.field_70761_aq = 0.0f;
        livingEntity.field_70177_z = 0.0f;
        livingEntity.field_70125_A = 0.0f;
        livingEntity.field_70759_as = livingEntity.field_70177_z;
        livingEntity.field_70758_at = livingEntity.field_70177_z;
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
        EntityRendererManager entityRendererManager = Minecraft.func_71410_x().func_175598_ae();
        entityRendererManager.func_178631_a(180.0f);
        entityRendererManager.func_178633_a(false);
        entityRendererManager.func_188391_a((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        entityRendererManager.func_178633_a(true);
        livingEntity.field_70761_aq = yBodyRot;
        livingEntity.field_70177_z = yRot;
        livingEntity.field_70125_A = xRot;
        livingEntity.field_70758_at = yHeadRotO;
        livingEntity.field_70759_as = yHeadRot;
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
    }

    private String getMessage(GuiOption option) {
        String buttonText = option.name();
        boolean value = false;
        if (option.equals((Object)GuiOption.CAPE)) {
            buttonText = "Custom Capes";
            value = MinecraftCapesConfig.isCapeVisible();
        } else if (option.equals((Object)GuiOption.EARS)) {
            buttonText = "Custom Ears";
            value = MinecraftCapesConfig.isEarsVisible();
        }
        String onOff = value ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
        return buttonText + ": " + onOff;
    }

    private static enum GuiOption {
        CAPE,
        EARS;

    }
}

