/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftcapes.MinecraftCapes;

public class PlayerHandler {
    private static HashMap<UUID, PlayerHandler> instances = new HashMap();
    private boolean hasStaticCape = false;
    private boolean hasEars = false;
    private boolean hasAnimatedCape = false;
    private Boolean showCape = true;
    private Boolean hasCapeGlint = false;
    private boolean upsideDown = false;
    private Boolean hasInfo = false;
    private UUID playerUUID;
    private HashMap<Integer, NativeImage> animatedCape;
    private long lastFrameTime = 0L;
    private int lastFrame = 0;
    private int capeInterval = 100;

    public PlayerHandler(UUID uuid) {
        this.playerUUID = uuid;
        instances.put(this.playerUUID, this);
    }

    @Deprecated
    public PlayerHandler(PlayerEntity player) {
        this.playerUUID = player.func_110124_au();
        instances.put(this.playerUUID, this);
    }

    public static PlayerHandler get(UUID uuid) {
        PlayerHandler playerHandler = instances.get(uuid);
        return playerHandler == null ? new PlayerHandler(uuid) : playerHandler;
    }

    @Deprecated
    public static PlayerHandler getFromPlayer(PlayerEntity player) {
        return PlayerHandler.get(player.func_110124_au());
    }

    public void applyCape(NativeImage capeImage) {
        if (capeImage.func_195714_b() != capeImage.func_195702_a() / 2) {
            HashMap<Integer, NativeImage> animatedCape = new HashMap<Integer, NativeImage>();
            int totalFrames = capeImage.func_195714_b() / (capeImage.func_195702_a() / 2);
            for (int currentFrame = 0; currentFrame < totalFrames; ++currentFrame) {
                NativeImage frame = new NativeImage(capeImage.func_195702_a(), capeImage.func_195702_a() / 2, true);
                for (int x = 0; x < frame.func_195702_a(); ++x) {
                    for (int y = 0; y < frame.func_195714_b(); ++y) {
                        frame.func_195700_a(x, y, capeImage.func_195709_a(x, y + currentFrame * (capeImage.func_195702_a() / 2)));
                    }
                }
                animatedCape.put(currentFrame, frame);
            }
            this.setAnimatedCape(animatedCape);
            MinecraftCapes.getLogger().debug("Animated cape loaded for {}", (Object)this.playerUUID);
        } else {
            int imageHeight;
            int imageWidth = 64;
            int srcWidth = capeImage.func_195702_a();
            int srcHeight = capeImage.func_195714_b();
            for (imageHeight = 32; imageWidth < srcWidth || imageHeight < srcHeight; imageWidth *= 2, imageHeight *= 2) {
            }
            NativeImage imgNew = new NativeImage(imageWidth, imageHeight, true);
            for (int x = 0; x < capeImage.func_195702_a(); ++x) {
                for (int y = 0; y < capeImage.func_195714_b(); ++y) {
                    imgNew.func_195700_a(x, y, capeImage.func_195709_a(x, y));
                }
            }
            this.applyTexture(new ResourceLocation("minecraftcapes", "capes/" + this.playerUUID), imgNew);
            this.setHasStaticCape(true);
            MinecraftCapes.getLogger().debug("Static cape loaded for {}", (Object)this.playerUUID);
        }
    }

    public void applyEars(NativeImage earImage) {
        this.applyTexture(new ResourceLocation("minecraftcapes", "ears/" + this.playerUUID), earImage);
        this.setHasEars(true);
    }

    public void removeCape() {
        if (!this.hasStaticCape && !this.hasAnimatedCape) {
            return;
        }
        MinecraftCapes.getLogger().debug("Removing cape for {}", (Object)this.playerUUID);
        this.setHasAnimatedCape(false);
        this.setHasStaticCape(false);
        Minecraft.func_71410_x().execute(() -> {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(new ResourceLocation("minecraftcapes", "capes/" + this.playerUUID));
            for (int i = 0; i < this.getAnimatedCape().size() - 1; ++i) {
                Minecraft.func_71410_x().func_110434_K().func_147645_c(new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, i)));
            }
        });
    }

    public void removeEars() {
        if (!this.hasEars) {
            return;
        }
        MinecraftCapes.getLogger().debug("Removing ears for {}", (Object)this.playerUUID);
        this.setHasEars(false);
        Minecraft.func_71410_x().execute(() -> Minecraft.func_71410_x().func_110434_K().func_147645_c(new ResourceLocation("minecraftcapes", "ears/" + this.playerUUID)));
    }

    public void setAnimatedCape(HashMap<Integer, NativeImage> animatedCape) {
        MinecraftCapes.getLogger().debug("Setting animated cape for {}", (Object)this.playerUUID);
        this.animatedCape = animatedCape;
        this.setHasAnimatedCape(true);
        this.loadFramesToResource();
    }

    private void loadFramesToResource() {
        MinecraftCapes.getLogger().debug("Loading resources to memory for {}", (Object)this.playerUUID);
        for (Map.Entry<Integer, NativeImage> entry : this.getAnimatedCape().entrySet()) {
            ResourceLocation currentResource = new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, entry.getKey()));
            this.applyTexture(currentResource, entry.getValue());
        }
    }

    private ResourceLocation getFrame() {
        long time = System.currentTimeMillis();
        if (time > this.lastFrameTime + (long)this.capeInterval) {
            int currentFrameNo;
            this.lastFrame = currentFrameNo = this.lastFrame + 1 > this.getAnimatedCape().size() - 1 ? 0 : this.lastFrame + 1;
            this.lastFrameTime = time;
            return new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, currentFrameNo));
        }
        return new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, this.lastFrame));
    }

    public ResourceLocation getCapeLocation() {
        return this.hasStaticCape ? new ResourceLocation("minecraftcapes", "capes/" + this.playerUUID) : (this.hasAnimatedCape ? this.getFrame() : null);
    }

    public ResourceLocation getEarLocation() {
        return this.hasEars ? new ResourceLocation("minecraftcapes", "ears/" + this.playerUUID) : null;
    }

    private void applyTexture(ResourceLocation resourceLocation, NativeImage nativeImage) {
        Minecraft.func_71410_x().execute(() -> Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, (ITextureObject)new DynamicTexture(nativeImage)));
    }

    public String toString() {
        return "PlayerHandler{hasStaticCape=" + this.hasStaticCape + ", hasEars=" + this.hasEars + ", hasAnimatedCape=" + this.hasAnimatedCape + ", hasCapeGlint=" + this.hasCapeGlint + ", upsideDown=" + this.upsideDown + ", hasInfo=" + this.hasInfo + ", playerUUID=" + this.playerUUID + ", animatedCape=" + this.animatedCape + ", lastFrameTime=" + this.lastFrameTime + ", lastFrame=" + this.lastFrame + ", capeInterval=" + this.capeInterval + '}';
    }

    @Generated
    public void setHasStaticCape(boolean hasStaticCape) {
        this.hasStaticCape = hasStaticCape;
    }

    @Generated
    public void setHasEars(boolean hasEars) {
        this.hasEars = hasEars;
    }

    @Generated
    public void setHasAnimatedCape(boolean hasAnimatedCape) {
        this.hasAnimatedCape = hasAnimatedCape;
    }

    @Generated
    public Boolean getShowCape() {
        return this.showCape;
    }

    @Generated
    public void setShowCape(Boolean showCape) {
        this.showCape = showCape;
    }

    @Generated
    public Boolean getHasCapeGlint() {
        return this.hasCapeGlint;
    }

    @Generated
    public void setHasCapeGlint(Boolean hasCapeGlint) {
        this.hasCapeGlint = hasCapeGlint;
    }

    @Generated
    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    @Generated
    public void setUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
    }

    @Generated
    public Boolean getHasInfo() {
        return this.hasInfo;
    }

    @Generated
    public void setHasInfo(Boolean hasInfo) {
        this.hasInfo = hasInfo;
    }

    @Generated
    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public HashMap<Integer, NativeImage> getAnimatedCape() {
        return this.animatedCape;
    }
}

