/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftcapes.MinecraftCapes;
import net.minecraftcapes.helpers.ImageHandler;
import net.minecraftcapes.helpers.MinecraftApi;
import net.minecraftcapes.player.PlayerHandler;
import org.apache.commons.io.IOUtils;

public class DownloadManager {
    public static void prepareDownload(UUID uuid, String username, boolean doRefresh) {
        PlayerHandler playerHandler = PlayerHandler.get(uuid);
        if (!playerHandler.getHasInfo().booleanValue() || doRefresh) {
            playerHandler.setHasInfo(true);
            if (uuid.version() == 4) {
                DownloadManager.downloadProfile(playerHandler);
            } else if (uuid.version() == 3) {
                Thread prepareProfile = new Thread(() -> {
                    UUID onlineUUID = MinecraftApi.getUUID(username);
                    if (onlineUUID != null) {
                        playerHandler.setPlayerUUID(onlineUUID);
                        DownloadManager.downloadProfile(playerHandler);
                    }
                });
                prepareProfile.start();
            }
        }
    }

    private static void downloadProfile(PlayerHandler playerHandler) {
        Thread playerDownload = new Thread(() -> {
            byte[] playerDataBytes = DownloadManager.downloadData("https://api.minecraftcapes.net/profile/" + playerHandler.getPlayerUUID().toString().replace("-", ""));
            if (playerDataBytes == null) {
                return;
            }
            String json = new String(playerDataBytes, StandardCharsets.UTF_8);
            ProfileResult profileResult = (ProfileResult)new Gson().fromJson(json, ProfileResult.class);
            playerHandler.setHasCapeGlint(profileResult.capeGlint);
            playerHandler.setUpsideDown(profileResult.upsideDown);
            if (profileResult.cape_url != null) {
                BufferedImage capeImage = DownloadManager.downloadOrLoad(profileResult.cape_url, "capes");
                if (capeImage != null) {
                    playerHandler.applyCape(capeImage);
                } else {
                    playerHandler.removeCape();
                }
            } else {
                playerHandler.removeCape();
            }
            if (profileResult.ear_url != null) {
                BufferedImage earsImage = DownloadManager.downloadOrLoad(profileResult.ear_url, "ears");
                if (earsImage != null) {
                    playerHandler.applyEars(earsImage);
                } else {
                    playerHandler.removeEars();
                }
            } else {
                playerHandler.removeEars();
            }
        });
        playerDownload.setDaemon(true);
        playerDownload.start();
    }

    private static BufferedImage downloadOrLoad(String url, String type) {
        BufferedImage bufferedImage;
        block19: {
            String hash = url.substring(url.lastIndexOf(47) + 1);
            Path cache = MinecraftCapes.getConfigDir().resolve(type).resolve(hash.length() > 2 ? hash.substring(0, 2) : "xx").resolve(hash);
            bufferedImage = null;
            if (cache.toFile().exists()) {
                try (InputStream inputStream = Files.newInputStream(cache.toFile().toPath(), new OpenOption[0]);){
                    bufferedImage = ImageHandler.legacyTransparencyFix(inputStream);
                    break block19;
                }
                catch (IOException e) {
                    MinecraftCapes.getLogger().error("IOException loading from cache {}", new Object[]{cache});
                    MinecraftCapes.getLogger().error(e.getMessage());
                    if (cache.toFile().delete()) {
                        return DownloadManager.downloadOrLoad(url, type);
                    }
                    return null;
                }
            }
            byte[] imageBytes = DownloadManager.downloadData(url);
            if (imageBytes != null) {
                try {
                    Files.createDirectories(cache.getParent(), new FileAttribute[0]);
                    Files.write(cache, imageBytes, new OpenOption[0]);
                    bufferedImage = ImageHandler.legacyTransparencyFix(new ByteArrayInputStream(imageBytes));
                }
                catch (IOException e) {
                    MinecraftCapes.getLogger().error("IOException saving cache {}", new Object[]{url});
                    MinecraftCapes.getLogger().error(e.getMessage());
                    return null;
                }
            }
        }
        return bufferedImage;
    }

    private static byte[] downloadData(String url) {
        HttpURLConnection httpURLConnection = null;
        URI uri = URI.create(url);
        try {
            MinecraftCapes.getLogger().info("Getting texture {}", new Object[]{url});
            httpURLConnection = (HttpURLConnection)uri.toURL().openConnection(Minecraft.func_71410_x().func_110437_J());
            httpURLConnection.setRequestProperty("User-Agent", "minecraftcapes-mod/1.9.4");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(false);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() / 100 == 2) {
                try (InputStream inputStream = httpURLConnection.getInputStream();){
                    byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                    return byArray;
                }
            }
            MinecraftCapes.getLogger().warn("minecraftcapes.net returned a {}", new Object[]{httpURLConnection.getResponseCode()});
        }
        catch (IOException e) {
            MinecraftCapes.getLogger().warn("No connection to minecraftcapes.net detected");
            throw new RuntimeException(e);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        byte[] inputStream = null;
        return inputStream;
    }

    private static class ProfileResult {
        private boolean capeGlint = false;
        private boolean upsideDown = false;
        private String cape_url = null;
        private String ear_url = null;

        private ProfileResult() {
        }
    }
}

